/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.builder;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.Datarouter;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.file.Pathbean;
import io.datarouter.storage.file.PathbeanKey;
import io.datarouter.storage.node.factory.BlobNodeFactory;
import io.datarouter.storage.node.op.NodeOps;
import io.datarouter.storage.node.op.raw.BlobStorage;
import io.datarouter.storage.util.Subpath;
import java.util.function.Supplier;

public class BlobNodeBuilder<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> {
    protected final Datarouter datarouter;
    protected final BlobNodeFactory blobNodeFactory;
    protected final ClientId clientId;
    protected final Supplier<D> databeanSupplier;
    protected final Supplier<F> fielderSupplier;
    protected String bucket;
    protected Subpath path;

    public BlobNodeBuilder(Datarouter datarouter, BlobNodeFactory blobNodeFactory, ClientId clientId, Supplier<D> databeanSupplier, Supplier<F> fielderSupplier) {
        this.datarouter = datarouter;
        this.blobNodeFactory = blobNodeFactory;
        this.clientId = clientId;
        this.databeanSupplier = databeanSupplier;
        this.fielderSupplier = fielderSupplier;
    }

    public <N extends NodeOps<PathbeanKey, Pathbean>> N build() {
        return this.blobNodeFactory.create(this.clientId, this.bucket, this.path);
    }

    public BlobStorage.PhysicalBlobStorageNode buildAndRegister() {
        return (BlobStorage.PhysicalBlobStorageNode)this.datarouter.register(this.blobNodeFactory.create(this.clientId, this.bucket, this.path));
    }
}

