/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.adapter.trace.physical;

import io.datarouter.instrumentation.trace.TraceSpanFinisher;
import io.datarouter.instrumentation.trace.TracerTool;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.adapter.PhysicalAdapterMixin;
import io.datarouter.storage.node.adapter.trace.BaseTraceAdapter;
import io.datarouter.storage.node.op.raw.TallyStorage;
import io.datarouter.storage.serialize.fieldcache.PhysicalDatabeanFieldInfo;
import io.datarouter.storage.tally.Tally;
import io.datarouter.storage.tally.TallyKey;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;

public class PhysicalTallyStorageTraceAdapter
extends BaseTraceAdapter<TallyKey, Tally, Tally.TallyFielder, TallyStorage.PhysicalTallyStorageNode>
implements TallyStorage.PhysicalTallyStorageNode,
PhysicalAdapterMixin<TallyKey, Tally, Tally.TallyFielder, TallyStorage.PhysicalTallyStorageNode> {
    public PhysicalTallyStorageTraceAdapter(TallyStorage.PhysicalTallyStorageNode backingNode) {
        super(backingNode);
    }

    @Override
    public PhysicalDatabeanFieldInfo<TallyKey, Tally, Tally.TallyFielder> getFieldInfo() {
        return PhysicalAdapterMixin.super.getFieldInfo();
    }

    @Override
    public Long incrementAndGetCount(String key, int delta, Config config) {
        Throwable throwable = null;
        Object var5_6 = null;
        try (TraceSpanFinisher $ = this.startSpanForOp("incrementAndGetCount");){
            return ((TallyStorage.PhysicalTallyStorageNode)this.getBackingNode()).incrementAndGetCount(key, delta, config);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Optional<Long> findTallyCount(String key, Config config) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (TraceSpanFinisher $ = this.startSpanForOp("findTallyCount");){
            Optional<Long> tallyCount = ((TallyStorage.PhysicalTallyStorageNode)this.getBackingNode()).findTallyCount(key, config);
            TracerTool.appendToSpanInfo((String)(tallyCount.isPresent() ? "hit" : "miss"));
            return tallyCount;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Map<String, Long> getMultiTallyCount(Collection<String> keys, Config config) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (TraceSpanFinisher $ = this.startSpanForOp("getMultiTallyCount");){
            Map<String, Long> tallyCounts = ((TallyStorage.PhysicalTallyStorageNode)this.getBackingNode()).getMultiTallyCount(keys, config);
            TracerTool.appendToSpanInfo((String)String.format("got %d/%d", tallyCounts.size(), keys.size()));
            return tallyCounts;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void deleteTally(String key, Config config) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (TraceSpanFinisher $ = this.startSpanForOp("deleteTally");){
            ((TallyStorage.PhysicalTallyStorageNode)this.getBackingNode()).deleteTally(key, config);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void vacuum(Config config) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (TraceSpanFinisher $ = this.startSpanForOp("vacuum");){
            ((TallyStorage.PhysicalTallyStorageNode)this.getBackingNode()).vacuum(config);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

