/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.adapter.sanitization.sanitizer;

import io.datarouter.model.field.Field;
import io.datarouter.model.field.FieldSet;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.util.tuple.Range;

public class ScanSanitizer {
    public static <PK extends PrimaryKey<PK>> void rejectUnexpectedFullScan(Range<PK> range) {
        if (range.hasStart() && ScanSanitizer.isMissingFirstField((FieldSet)range.getStart())) {
            String message = String.format("Unexpected full scan error: startKey exists but with null first field.  range=%s", range);
            throw new RuntimeException(message);
        }
        if (range.hasEnd() && ScanSanitizer.isMissingFirstField((FieldSet)range.getEnd())) {
            String message = String.format("Unexpected full scan error: endKey exists but with null first field.  range=%s", range);
            throw new RuntimeException(message);
        }
    }

    private static boolean isMissingFirstField(FieldSet<?> key) {
        return ((Field)key.getFields().iterator().next()).getValue() == null;
    }
}

