/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.adapter.sanitization.sanitizer;

import io.datarouter.model.field.Field;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.scanner.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimaryKeySanitizer {
    private static final Logger logger = LoggerFactory.getLogger(PrimaryKeySanitizer.class);

    public static void checkForNullPrimaryKeyValues(PrimaryKey<?> pk) {
        Scanner.of((Iterable)pk.getFields()).exclude(field -> field.getKey().getAutoGeneratedType().isGenerated()).include(field -> field.getValue() == null).findFirst().map(Field::getPrefixedName).ifPresent(fieldName -> {
            throw new RuntimeException("null value detected for field=" + fieldName + " in PK=" + pk);
        });
    }

    public static void logForNullPrimaryKeyValues(PrimaryKey<?> pk) {
        Scanner.of((Iterable)pk.getFields()).include(field -> field.getValue() == null).map(Field::getPrefixedName).forEach(fieldName -> {
            if (logger.isDebugEnabled()) {
                logger.warn("null value key={} field={}", new Object[]{pk, fieldName, new Exception()});
            } else {
                logger.warn("null value key={} field={}", (Object)pk, fieldName);
            }
        });
    }
}

