/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.adapter.sanitization.mixin;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.adapter.sanitization.SanitizationAdapter;
import io.datarouter.storage.node.adapter.sanitization.sanitizer.ScanSanitizer;
import io.datarouter.storage.node.op.raw.SortedStorage;
import io.datarouter.util.tuple.Range;
import java.util.Collection;
import java.util.Objects;

public interface SortedStorageSanitizationAdapterMixin<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends SortedStorage.SortedStorageNode<PK, D, F>>
extends SortedStorage<PK, D>,
SanitizationAdapter<PK, D, F, N> {
    @Override
    default public Scanner<PK> scanKeys(Range<PK> range, Config config) {
        Objects.requireNonNull(range);
        Objects.requireNonNull(config);
        if (range.isEmpty()) {
            return Scanner.empty();
        }
        ScanSanitizer.rejectUnexpectedFullScan(range);
        return ((SortedStorage.SortedStorageNode)this.getBackingNode()).scanKeys(range, config);
    }

    @Override
    default public Scanner<PK> scanRangesKeys(Collection<Range<PK>> ranges, Config config) {
        Objects.requireNonNull(ranges);
        Objects.requireNonNull(config);
        ranges.forEach(Objects::requireNonNull);
        if (Scanner.of(ranges).allMatch(Range::isEmpty)) {
            return Scanner.empty();
        }
        ranges.forEach(ScanSanitizer::rejectUnexpectedFullScan);
        return ((SortedStorage.SortedStorageNode)this.getBackingNode()).scanRangesKeys(ranges, config);
    }

    @Override
    default public Scanner<D> scan(Range<PK> range, Config config) {
        Objects.requireNonNull(range);
        Objects.requireNonNull(config);
        if (range.isEmpty()) {
            return Scanner.empty();
        }
        ScanSanitizer.rejectUnexpectedFullScan(range);
        return ((SortedStorage.SortedStorageNode)this.getBackingNode()).scan(range, config);
    }

    @Override
    default public Scanner<D> scanRanges(Collection<Range<PK>> ranges, Config config) {
        Objects.requireNonNull(ranges);
        Objects.requireNonNull(config);
        ranges.forEach(Objects::requireNonNull);
        if (Scanner.of(ranges).allMatch(Range::isEmpty)) {
            return Scanner.empty();
        }
        ranges.forEach(ScanSanitizer::rejectUnexpectedFullScan);
        return ((SortedStorage.SortedStorageNode)this.getBackingNode()).scanRanges(ranges, config);
    }
}

