/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.adapter.sanitization.mixin;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.field.Field;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.adapter.sanitization.mixin.MapStorageReaderSanitizationAdapterMixin;
import io.datarouter.storage.node.adapter.sanitization.sanitizer.PrimaryKeySanitizer;
import io.datarouter.storage.node.op.raw.MapStorage;
import java.util.Collection;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface MapStorageSanitizationAdapterMixin<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends MapStorage.MapStorageNode<PK, D, F>>
extends MapStorage<PK, D>,
MapStorageReaderSanitizationAdapterMixin<PK, D, F, N> {
    public static final Logger logger = LoggerFactory.getLogger(MapStorageSanitizationAdapterMixin.class);

    @Override
    default public void put(D databean, Config config) {
        Objects.requireNonNull(databean);
        Objects.requireNonNull(config);
        PrimaryKeySanitizer.checkForNullPrimaryKeyValues(databean.getKey());
        this.validate(databean);
        ((MapStorage.MapStorageNode)this.getBackingNode()).put(databean, config);
    }

    @Override
    default public void putMulti(Collection<D> databeans, Config config) {
        Objects.requireNonNull(databeans);
        Objects.requireNonNull(config);
        if (databeans.isEmpty()) {
            return;
        }
        databeans.forEach(Objects::requireNonNull);
        Scanner.of(databeans).map(Databean::getKey).forEach(PrimaryKeySanitizer::checkForNullPrimaryKeyValues);
        databeans.forEach(this::validate);
        ((MapStorage.MapStorageNode)this.getBackingNode()).putMulti(databeans, config);
    }

    @Override
    default public void delete(PK key, Config config) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(config);
        ((MapStorage.MapStorageNode)this.getBackingNode()).delete(key, config);
    }

    @Override
    default public void deleteMulti(Collection<PK> keys, Config config) {
        Objects.requireNonNull(keys);
        Objects.requireNonNull(config);
        if (keys.isEmpty()) {
            return;
        }
        keys.forEach(Objects::requireNonNull);
        ((MapStorage.MapStorageNode)this.getBackingNode()).deleteMulti(keys, config);
    }

    @Override
    default public void deleteAll(Config config) {
        Objects.requireNonNull(config);
        ((MapStorage.MapStorageNode)this.getBackingNode()).deleteAll(config);
    }

    private void validate(D databean) {
        ((MapStorage.MapStorageNode)this.getBackingNode()).getFieldInfo().getFieldsWithValues(databean).forEach(Field::validate);
    }
}

