/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.adapter.sanitization;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.adapter.sanitization.BaseSanitizationAdapter;
import io.datarouter.storage.node.adapter.sanitization.sanitizer.PrimaryKeySanitizer;
import io.datarouter.storage.node.op.raw.write.QueueStorageWriter;
import io.datarouter.storage.queue.QueueMessageKey;
import java.util.Collection;
import java.util.Objects;

public class QueueStorageWriterSanitizationAdapter<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends QueueStorageWriter.PhysicalQueueStorageWriterNode<PK, D, F>>
extends BaseSanitizationAdapter<PK, D, F, N>
implements QueueStorageWriter<PK, D> {
    public QueueStorageWriterSanitizationAdapter(N backingNode) {
        super(backingNode);
    }

    @Override
    public void ack(QueueMessageKey key, Config config) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(config);
        ((QueueStorageWriter.PhysicalQueueStorageWriterNode)this.backingNode).ack(key, config);
    }

    @Override
    public void ackMulti(Collection<QueueMessageKey> keys, Config config) {
        Objects.requireNonNull(keys);
        Objects.requireNonNull(config);
        keys.forEach(Objects::requireNonNull);
        if (keys.isEmpty()) {
            return;
        }
        ((QueueStorageWriter.PhysicalQueueStorageWriterNode)this.backingNode).ackMulti(keys, config);
    }

    @Override
    public void put(D databean, Config config) {
        Objects.requireNonNull(databean);
        Objects.requireNonNull(config);
        PrimaryKeySanitizer.checkForNullPrimaryKeyValues(databean.getKey());
        ((QueueStorageWriter.PhysicalQueueStorageWriterNode)this.backingNode).put(databean, config);
    }

    @Override
    public void putMulti(Collection<D> databeans, Config config) {
        Objects.requireNonNull(databeans);
        Objects.requireNonNull(config);
        databeans.forEach(Objects::requireNonNull);
        if (databeans.isEmpty()) {
            return;
        }
        Scanner.of(databeans).map(Databean::getKey).forEach(PrimaryKeySanitizer::checkForNullPrimaryKeyValues);
        ((QueueStorageWriter.PhysicalQueueStorageWriterNode)this.backingNode).putMulti(databeans, config);
    }
}

