/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.adapter.counter.mixin;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.adapter.counter.CounterAdapter;
import io.datarouter.storage.node.op.raw.read.MapStorageReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface MapStorageReaderCounterAdapterMixin<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends MapStorageReader.MapStorageReaderNode<PK, D, F>>
extends MapStorageReader<PK, D>,
CounterAdapter<PK, D, F, N> {
    public static final Logger logger = LoggerFactory.getLogger(MapStorageReaderCounterAdapterMixin.class);

    @Override
    default public boolean exists(PK key, Config config) {
        String opName = "exists";
        this.getCounter().count(opName);
        boolean result = ((MapStorageReader.MapStorageReaderNode)this.getBackingNode()).exists(key, config);
        String hitOrMiss = result ? "hit" : "miss";
        this.getCounter().count(String.valueOf(opName) + " " + hitOrMiss);
        return result;
    }

    @Override
    default public D get(PK key, Config config) {
        String opName = "get";
        this.getCounter().count(opName);
        Object result = ((MapStorageReader.MapStorageReaderNode)this.getBackingNode()).get(key, config);
        String hitOrMiss = result != null ? "hit" : "miss";
        this.getCounter().count(String.valueOf(opName) + " " + hitOrMiss);
        return result;
    }

    @Override
    default public List<D> getMulti(Collection<PK> keys, Config config) {
        if (keys == null || keys.isEmpty()) {
            return new ArrayList();
        }
        String opName = "getMulti";
        this.getCounter().count(opName);
        this.getCounter().count(String.valueOf(opName) + " keys", keys.size());
        List results = ((MapStorageReader.MapStorageReaderNode)this.getBackingNode()).getMulti(keys, config);
        int numHits = results.size();
        int numMisses = keys.size() - numHits;
        if (numMisses < 0) {
            logger.warn("negative misses on {}, numKeys={}, numHits={}, numMisses={}, keys={}, results={}", new Object[]{((MapStorageReader.MapStorageReaderNode)this.getBackingNode()).getName(), keys.size(), numHits, numMisses, keys, Scanner.of(results).map(Databean::getKey).list()});
        }
        this.getCounter().count(String.valueOf(opName) + " hit", numHits);
        this.getCounter().count(String.valueOf(opName) + " miss", numMisses);
        return results;
    }

    @Override
    default public List<PK> getKeys(Collection<PK> keys, Config config) {
        if (keys == null || keys.isEmpty()) {
            return new ArrayList();
        }
        String opName = "getKeys";
        this.getCounter().count(opName);
        this.getCounter().count(String.valueOf(opName) + " keys", keys.size());
        List<PK> results = ((MapStorageReader.MapStorageReaderNode)this.getBackingNode()).getKeys(keys, config);
        int numHits = results.size();
        int numMisses = keys.size() - numHits;
        this.getCounter().count(String.valueOf(opName) + " hit", numHits);
        this.getCounter().count(String.valueOf(opName) + " miss", numMisses);
        return results;
    }
}

