/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.scanner.OptionalScanner;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientType;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.file.PathbeanKey;
import io.datarouter.storage.node.DatabeanToBlobCodec;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.op.raw.BlobStorage;
import io.datarouter.storage.node.op.raw.MapStorage;
import io.datarouter.storage.node.type.physical.base.BasePhysicalNode;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class DatabeanToBlobNode<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>>
extends BasePhysicalNode<PK, D, F>
implements MapStorage.PhysicalMapStorageNode<PK, D, F> {
    private final BlobStorage.PhysicalBlobStorageNode blobNode;
    private final DatabeanToBlobCodec<PK, D, F> codec;

    public DatabeanToBlobNode(NodeParams<PK, D, F> params, ClientType<?, ?> clientType, BlobStorage.PhysicalBlobStorageNode blobNode, DatabeanToBlobCodec<PK, D, F> codec) {
        super(params, clientType);
        this.blobNode = blobNode;
        this.codec = codec;
    }

    @Override
    public boolean exists(PK key, Config config) {
        return this.codec.encodeKeyIfValid(key).map(encodedKey -> this.blobNode.exists((PathbeanKey)((Object)encodedKey), config)).orElse(false);
    }

    @Override
    public List<PK> getKeys(Collection<PK> keys, Config config) {
        return this.scanMultiInternal(keys, config).map(Databean::getKey).list();
    }

    @Override
    public D get(PK key, Config config) {
        return (D)((Databean)this.scanMultiInternal(List.of(key), config).findFirst().orElse(null));
    }

    @Override
    public List<D> getMulti(Collection<PK> keys, Config config) {
        return this.scanMultiInternal(keys, config).list();
    }

    @Override
    public void delete(PK key, Config config) {
        this.deleteMulti(List.of(key), config);
    }

    @Override
    public void deleteMulti(Collection<PK> keys, Config config) {
        Scanner.of(keys).map(this.codec::encodeKeyIfValid).concat(OptionalScanner::of).forEach(encodedKey -> this.blobNode.delete((PathbeanKey)((Object)encodedKey), config));
    }

    @Override
    public void deleteAll(Config config) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void put(D databean, Config config) {
        this.putMulti(List.of(databean), config);
    }

    @Override
    public void putMulti(Collection<D> databeans, Config config) {
        Scanner.of(databeans).map(this.codec::encodeDatabeanIfValid).concat(OptionalScanner::of).forEach(keyAndValue -> this.blobNode.write(keyAndValue.pathbeanKey(), keyAndValue.value(), config));
    }

    private Scanner<D> scanMultiInternal(Collection<PK> keys, Config config) {
        Map bytesByKey = (Map)Scanner.of(keys).map(this.codec::encodeKeyIfValid).concat(OptionalScanner::of).listTo(encodedKeys -> this.blobNode.read((List<PathbeanKey>)encodedKeys, config));
        return Scanner.of(bytesByKey.values()).map(this.codec::decodeDatabean);
    }
}

