/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.databean.DatabeanTool;
import io.datarouter.model.field.Field;
import io.datarouter.model.field.FieldSetTool;
import io.datarouter.model.field.FieldTool;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.file.PathbeanKey;
import io.datarouter.storage.util.Subpath;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabeanToBlobCodec<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> {
    private static final Logger logger = LoggerFactory.getLogger(DatabeanToBlobCodec.class);
    public static final String CODEC_VERSION = "1";
    private final String clientTypeName;
    private final DatabeanFielder<PK, D> fielder;
    private final Supplier<D> databeanSupplier;
    private final Map<String, Field<?>> fieldByPrefixedName;
    private final Subpath path;
    private final int clientMaxValueLength;
    private final int pathLength;
    private final int maxKeyLength;

    public DatabeanToBlobCodec(String clientTypeName, DatabeanFielder<PK, D> fielder, Supplier<D> databeanSupplier, Map<String, Field<?>> fieldByPrefixedName, Subpath path, int clientMaxKeyLength, int clientMaxValueLength) {
        this.clientTypeName = clientTypeName;
        this.fielder = fielder;
        this.databeanSupplier = databeanSupplier;
        this.fieldByPrefixedName = fieldByPrefixedName;
        this.path = path;
        this.clientMaxValueLength = clientMaxValueLength;
        this.pathLength = path.toString().length();
        this.maxKeyLength = clientMaxKeyLength - this.pathLength;
    }

    public Optional<PathBbeanKeyAndValue> encodeDatabeanIfValid(D databean) {
        Optional<PathbeanKey> pathbeanKey = this.encodeKeyIfValid(databean.getKey());
        if (pathbeanKey.isEmpty()) {
            return Optional.empty();
        }
        byte[] value = this.encodeDatabean(databean);
        if (value.length > this.clientMaxValueLength) {
            logger.warn("object too big for {} length={} key={}", new Object[]{this.clientTypeName, value.length, databean.getKey()});
            return Optional.empty();
        }
        return Optional.of(new PathBbeanKeyAndValue(pathbeanKey.orElseThrow(), value));
    }

    public Optional<PathbeanKey> encodeKeyIfValid(PK pk) {
        PathbeanKey pathbeanKey = this.encodeKey(pk);
        String encodedKey = pathbeanKey.getPathAndFile();
        if (pathbeanKey.getPathAndFile().length() > this.maxKeyLength) {
            logger.warn("key too long for {} length={} nodeSubpathLength={} maxKeyLength={} key={} encodedKey={}", new Object[]{this.clientTypeName, encodedKey.length(), this.pathLength, this.maxKeyLength, pk, this.path + encodedKey});
            return Optional.empty();
        }
        return Optional.of(pathbeanKey);
    }

    public D decodeDatabean(byte[] bytes) {
        return (D)((Databean)FieldSetTool.fieldSetFromBytes(this.databeanSupplier, this.fieldByPrefixedName, (byte[])bytes));
    }

    private PathbeanKey encodeKey(PK pk) {
        byte[] bytes = FieldTool.getConcatenatedValueBytes((List)pk.getFields());
        String string = Base64.getUrlEncoder().encodeToString(bytes);
        return PathbeanKey.of(string);
    }

    private byte[] encodeDatabean(D databean) {
        return DatabeanTool.getBytes(databean, this.fielder);
    }

    public record PathBbeanKeyAndValue(PathbeanKey pathbeanKey, byte[] value) {
    }
}

