/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.file;

import io.datarouter.model.field.Field;
import io.datarouter.model.field.imp.StringField;
import io.datarouter.model.field.imp.StringFieldKey;
import io.datarouter.model.key.primary.base.BaseRegularPrimaryKey;
import io.datarouter.storage.util.Subpath;
import io.datarouter.util.Require;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;

public class PathbeanKey
extends BaseRegularPrimaryKey<PathbeanKey> {
    private String path;
    private String file;

    public List<Field<?>> getFields() {
        return List.of(new StringField(FieldKeys.path, this.path), new StringField(FieldKeys.file, this.file));
    }

    public PathbeanKey() {
    }

    public PathbeanKey(String path, String file) {
        this(path, file, false);
    }

    private PathbeanKey(String path, String file, boolean allowEmptyFile) {
        boolean isValidFile;
        boolean isValidPath = path == null || PathbeanKey.isValidPath(path);
        boolean bl = isValidFile = file == null || PathbeanKey.isValidFile(file, allowEmptyFile);
        if (!isValidPath || !isValidFile) {
            String message = String.format("validPath=%s, validFile=%s in [path=%s][file=%s]", isValidPath, isValidFile, path, file);
            throw new IllegalArgumentException(message);
        }
        this.path = path;
        this.file = file;
    }

    public static PathbeanKey ofAllowEmptyFile(String pathAndFile) {
        return PathbeanKey.of(pathAndFile, true);
    }

    public static PathbeanKey of(String pathAndFile) {
        return PathbeanKey.of(pathAndFile, false);
    }

    private static PathbeanKey of(String pathAndFile, boolean allowEmptyFile) {
        String keyFile;
        String keyDirectory;
        int lastSlashIndex = pathAndFile.lastIndexOf(47);
        if (lastSlashIndex < 0) {
            keyDirectory = "";
            keyFile = pathAndFile;
        } else {
            keyDirectory = pathAndFile.substring(0, lastSlashIndex + 1);
            keyFile = pathAndFile.substring(lastSlashIndex + 1);
        }
        return new PathbeanKey(keyDirectory, keyFile, allowEmptyFile);
    }

    public static PathbeanKey of(Path path) {
        Require.greaterThan((Comparable)Integer.valueOf(path.getNameCount()), (Comparable)Integer.valueOf(0));
        int nameCount = path.getNameCount();
        String keyPath = nameCount == 1 ? "" : path.subpath(0, nameCount - 1) + "/";
        String keyFile = path.getFileName().toString();
        return new PathbeanKey(keyPath, keyFile);
    }

    public static PathbeanKey of(Subpath subpath, String file) {
        Require.notNull((Object)subpath);
        Require.notNull((Object)file);
        return new PathbeanKey(subpath.toString(), file);
    }

    public static final boolean isValidPath(String path) {
        if (path.isEmpty()) {
            return true;
        }
        if (path.startsWith("/")) {
            return false;
        }
        if (path.contains("//")) {
            return false;
        }
        return path.endsWith("/");
    }

    public static final boolean isValidFile(String file, boolean allowEmptyFile) {
        if (file.contains("/")) {
            return false;
        }
        if (file.length() == 0) {
            return allowEmptyFile;
        }
        return true;
    }

    public String getPathAndFile() {
        return String.valueOf(this.path) + this.file;
    }

    public String getPath() {
        return this.path;
    }

    public String getFile() {
        return this.file;
    }

    public Optional<String> findFirstPathSegment() {
        if (this.path.isEmpty()) {
            return Optional.empty();
        }
        int firstSlashPosition = this.path.indexOf(47);
        String firstSegment = this.path.substring(0, firstSlashPosition);
        return Optional.of(firstSegment);
    }

    public List<String> getPathSegments() {
        if (this.path.isEmpty()) {
            return List.of();
        }
        return List.of(this.path.split("/"));
    }

    public Subpath getSubpath() {
        return new Subpath(this.getPathSegments());
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "." + this.getPathAndFile();
    }

    public static class FieldKeys {
        public static final StringFieldKey path = new StringFieldKey("path");
        public static final StringFieldKey file = new StringFieldKey("file");
    }
}

