/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.file;

import io.datarouter.bytes.ByteLength;
import io.datarouter.bytes.ByteTool;
import io.datarouter.bytes.CountingInputStream;
import io.datarouter.instrumentation.count.Counters;
import io.datarouter.scanner.Scanner;
import io.datarouter.scanner.Threads;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.file.Pathbean;
import io.datarouter.storage.file.PathbeanKey;
import io.datarouter.storage.node.op.raw.BlobStorage;
import io.datarouter.storage.util.Subpath;
import io.datarouter.util.Require;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class Directory
implements BlobStorage {
    private static final int INPUT_STREAM_COUNT_INTERVAL = ByteLength.ofKiB((long)256L).toBytesInt();
    private final BlobStorage parent;
    private final Subpath subpathInParent;
    private final Optional<String> optCounterName;

    public Directory(BlobStorage parent) {
        this(parent, Subpath.empty(), null);
    }

    public Directory(BlobStorage parent, Subpath subpathInParent) {
        this(parent, subpathInParent, null);
    }

    private Directory(BlobStorage parent, Subpath subpathInParent, String counterName) {
        this.parent = Objects.requireNonNull(parent);
        this.subpathInParent = Objects.requireNonNull(subpathInParent);
        this.optCounterName = Optional.ofNullable(counterName);
    }

    public Directory subdirectory(Subpath subpathInParent) {
        return this.subdirectoryBuilder(subpathInParent).build();
    }

    public SubdirectoryBuilder subdirectoryBuilder(Subpath subpathInParent) {
        return new SubdirectoryBuilder(this, subpathInParent);
    }

    @Override
    public void write(PathbeanKey key, byte[] value, Config config) {
        this.parent.write(this.prependStoragePath(key), value, config);
        this.count(CounterSuffix.WRITE_OPS, 1L);
        this.count(CounterSuffix.WRITE_BYTES, value.length);
    }

    @Override
    public void write(PathbeanKey key, InputStream inputStream, Config config) {
        CountingInputStream countingInputStream = new CountingInputStream(inputStream, INPUT_STREAM_COUNT_INTERVAL, numBytes -> this.count(CounterSuffix.WRITE_INPUT_STREAM_BYTES, (long)numBytes));
        this.parent.write(this.prependStoragePath(key), (InputStream)countingInputStream, config);
        this.count(CounterSuffix.WRITE_INPUT_STREAM_OPS, 1L);
    }

    @Override
    public void writeParallel(PathbeanKey key, InputStream inputStream, Threads threads, ByteLength minPartSize, Config config) {
        CountingInputStream countingInputStream = new CountingInputStream(inputStream, INPUT_STREAM_COUNT_INTERVAL, numBytes -> this.count(CounterSuffix.WRITE_INPUT_STREAM_BYTES, (long)numBytes));
        this.parent.writeParallel(this.prependStoragePath(key), (InputStream)countingInputStream, threads, minPartSize, config);
        this.count(CounterSuffix.WRITE_INPUT_STREAM_OPS, 1L);
    }

    @Override
    public void writeParallel(PathbeanKey key, Scanner<List<byte[]>> parts, Threads threads, Config config) {
        Scanner countedParts = parts.each(part -> {
            this.count(CounterSuffix.WRITE_PARTS_PARTS, 1L);
            this.count(CounterSuffix.WRITE_PARTS_BYTES, ByteTool.totalLength((List)part));
        });
        this.parent.writeParallel(this.prependStoragePath(key), (Scanner<List<byte[]>>)countedParts, threads, config);
        this.count(CounterSuffix.WRITE_PARTS_OPS, 1L);
    }

    @Override
    public void delete(PathbeanKey key, Config config) {
        this.parent.delete(this.prependStoragePath(key), config);
        this.count(CounterSuffix.DELETE_OPS, 1L);
    }

    @Override
    public void deleteAll(Subpath subpath, Config config) {
        this.parent.deleteAll(this.subpathInParent.append(subpath), config);
        this.count(CounterSuffix.DELETE_ALL_OPS, 1L);
    }

    @Override
    public String getBucket() {
        return this.parent.getBucket();
    }

    @Override
    public Subpath getRootPath() {
        return this.parent.getRootPath().append(this.subpathInParent);
    }

    @Override
    public boolean exists(PathbeanKey key, Config config) {
        boolean exists = this.parent.exists(this.prependStoragePath(key), config);
        this.count(CounterSuffix.EXISTS_OPS, 1L);
        return exists;
    }

    @Override
    public Optional<Long> length(PathbeanKey key, Config config) {
        Optional<Long> optLength = this.parent.length(this.prependStoragePath(key), config);
        this.count(CounterSuffix.LENGTH_OPS, 1L);
        return optLength;
    }

    @Override
    public byte[] read(PathbeanKey key, Config config) {
        Optional<byte[]> optBytes = Optional.ofNullable(this.parent.read(this.prependStoragePath(key), config));
        this.count(CounterSuffix.READ_OPS, 1L);
        optBytes.map(bytes -> ((byte[])bytes).length).ifPresent(length -> this.count(CounterSuffix.READ_BYTES, length.intValue()));
        return optBytes.orElse(null);
    }

    @Override
    public byte[] read(PathbeanKey key, long offset, int length, Config config) {
        Optional<byte[]> optBytes = Optional.ofNullable(this.parent.read(this.prependStoragePath(key), offset, length, config));
        this.count(CounterSuffix.READ_OFFSET_LIMIT_OPS, 1L);
        optBytes.map(bytes -> ((byte[])bytes).length).ifPresent(actualLength -> this.count(CounterSuffix.READ_OFFSET_LIMIT_BYTES, actualLength.intValue()));
        return optBytes.orElse(null);
    }

    @Override
    public Map<PathbeanKey, byte[]> read(List<PathbeanKey> keys, Config config) {
        HashMap<PathbeanKey, byte[]> keyValue = new HashMap<PathbeanKey, byte[]>();
        keys.forEach(key -> {
            Optional<byte[]> optBytes = Optional.ofNullable(this.parent.read(this.prependStoragePath((PathbeanKey)((Object)key)), config));
            this.count(CounterSuffix.READ_OPS, 1L);
            optBytes.map(bytes -> ((byte[])bytes).length).ifPresent(actualLength -> this.count(CounterSuffix.READ_BYTES, actualLength.intValue()));
            keyValue.putIfAbsent((PathbeanKey)((Object)key), optBytes.orElse(null));
        });
        return keyValue;
    }

    @Override
    public InputStream readInputStream(PathbeanKey key, Config config) {
        this.count(CounterSuffix.READ_INPUT_STREAM_OPS, 1L);
        return new CountingInputStream(this.parent.readInputStream(this.prependStoragePath(key), config), INPUT_STREAM_COUNT_INTERVAL, numBytes -> this.count(CounterSuffix.READ_INPUT_STREAM_BYTES, (long)numBytes));
    }

    @Override
    public Scanner<List<PathbeanKey>> scanKeysPaged(Subpath subpath, Config config) {
        return this.parent.scanKeysPaged(this.subpathInParent.append(subpath), config).map(keys -> Scanner.of((Iterable)keys).map(this::removeStoragePath).list()).each($ -> this.count(CounterSuffix.SCAN_KEYS_OPS, 1L)).each(page -> this.count(CounterSuffix.SCAN_KEYS_ITEMS, page.size()));
    }

    @Override
    public Scanner<List<Pathbean>> scanPaged(Subpath subpath, Config config) {
        return this.parent.scanPaged(this.subpathInParent.append(subpath), config).map(page -> Scanner.of((Iterable)page).map(pathbean -> new Pathbean(this.removeStoragePath((PathbeanKey)pathbean.getKey()), pathbean.getSize())).list()).each($ -> this.count(CounterSuffix.SCAN_OPS, 1L)).each(page -> this.count(CounterSuffix.SCAN_ITEMS, page.size()));
    }

    private PathbeanKey prependStoragePath(PathbeanKey directoryKey) {
        Subpath storagePath = this.subpathInParent.append(directoryKey.getSubpath());
        return PathbeanKey.of(storagePath, directoryKey.getFile());
    }

    private PathbeanKey removeStoragePath(PathbeanKey storageKey) {
        String storagePath = storageKey.getPath();
        Require.isTrue((boolean)storagePath.startsWith(this.subpathInParent.toString()));
        String directoryPath = storagePath.substring(this.subpathInParent.toString().length());
        return new PathbeanKey(directoryPath, storageKey.getFile());
    }

    private void count(CounterSuffix suffix, long by) {
        this.optCounterName.ifPresent(counterName -> {
            String name = String.format("Directory %s %s", counterName, counterSuffix.suffix);
            Counters.inc((String)name, (long)by);
        });
    }

    public String toString() {
        return this.getRootPath().toString();
    }

    @Override
    public void vacuum(Config config) {
        throw new UnsupportedOperationException();
    }

    private static enum CounterSuffix {
        DELETE_ALL_OPS("deleteAll ops"),
        DELETE_OPS("delete ops"),
        EXISTS_OPS("exists ops"),
        LENGTH_OPS("length ops"),
        READ_BYTES("read bytes"),
        READ_INPUT_STREAM_BYTES("readInputStream bytes"),
        READ_INPUT_STREAM_OPS("readInputStream ops"),
        READ_OPS("read ops"),
        READ_OFFSET_LIMIT_BYTES("readOffsetLimit bytes"),
        READ_OFFSET_LIMIT_OPS("readOffsetLimit ops"),
        SCAN_KEYS_OPS("scanKeys ops"),
        SCAN_KEYS_ITEMS("scanKeys items"),
        SCAN_OPS("scan ops"),
        SCAN_ITEMS("scan items"),
        WRITE_BYTES("write bytes"),
        WRITE_OPS("write ops"),
        WRITE_INPUT_STREAM_BYTES("writeInputStream bytes"),
        WRITE_INPUT_STREAM_OPS("writeInputStream ops"),
        WRITE_PARTS_BYTES("writeParts bytes"),
        WRITE_PARTS_OPS("writeParts ops"),
        WRITE_PARTS_PARTS("writeParts parts");

        public final String suffix;

        private CounterSuffix(String suffix) {
            this.suffix = suffix;
        }
    }

    public static class DirectoryBuilder {
        private final BlobStorage parent;
        private Subpath subpathInParent;
        private String counterName;

        public DirectoryBuilder(BlobStorage parent) {
            this.parent = Objects.requireNonNull(parent);
            this.subpathInParent = Subpath.empty();
        }

        public DirectoryBuilder withSubpathInParent(Subpath subpathInParent) {
            this.subpathInParent = Objects.requireNonNull(subpathInParent);
            return this;
        }

        public DirectoryBuilder withCounterName(String counterName) {
            this.counterName = Objects.requireNonNull(counterName);
            return this;
        }

        public Directory build() {
            return new Directory(this.parent, this.subpathInParent, this.counterName);
        }
    }

    public static class SubdirectoryBuilder {
        private final DirectoryBuilder directoryBuilder;

        public SubdirectoryBuilder(BlobStorage parent, Subpath subpathInParent) {
            this.directoryBuilder = new DirectoryBuilder(parent).withSubpathInParent(subpathInParent);
        }

        public SubdirectoryBuilder withCounterName(String counterName) {
            this.directoryBuilder.withCounterName(counterName);
            return this;
        }

        public Directory build() {
            return this.directoryBuilder.build();
        }
    }
}

