/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.file;

import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.model.field.Field;
import io.datarouter.model.field.imp.array.ByteArrayField;
import io.datarouter.model.field.imp.array.ByteArrayFieldKey;
import io.datarouter.model.field.imp.comparable.LongField;
import io.datarouter.model.field.imp.comparable.LongFieldKey;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.BaseDatabeanFielder;
import io.datarouter.storage.file.DatabaseBlobKey;
import io.datarouter.storage.file.PathbeanKey;
import java.util.List;
import java.util.function.Supplier;

public class DatabaseBlob
extends BaseDatabean<DatabaseBlobKey, DatabaseBlob> {
    private Long size;
    private byte[] data;
    private Long expirationMs;

    public DatabaseBlob() {
        super((PrimaryKey)new DatabaseBlobKey());
    }

    public DatabaseBlob(DatabaseBlobKey key) {
        super((PrimaryKey)key);
    }

    public DatabaseBlob(DatabaseBlobKey key, Long size) {
        super((PrimaryKey)key);
        this.size = size;
    }

    public DatabaseBlob(PathbeanKey key, byte[] data, Long expirationMs) {
        this(key, data, Long.valueOf(data.length), expirationMs);
    }

    public DatabaseBlob(PathbeanKey key, byte[] data, Long size, Long expirationMs) {
        super((PrimaryKey)new DatabaseBlobKey(key));
        this.size = size;
        this.data = data;
        this.expirationMs = expirationMs;
    }

    public Supplier<DatabaseBlobKey> getKeySupplier() {
        return DatabaseBlobKey::new;
    }

    public Long getSize() {
        return this.size;
    }

    public byte[] getData() {
        return this.data;
    }

    public Long getExpirationMs() {
        return this.expirationMs;
    }

    public static class DatabaseBlobFielder
    extends BaseDatabeanFielder<DatabaseBlobKey, DatabaseBlob> {
        public DatabaseBlobFielder() {
            super(DatabaseBlobKey::new);
        }

        public List<Field<?>> getNonKeyFields(DatabaseBlob databean) {
            return List.of(new LongField(FieldKeys.size, databean.size), new ByteArrayField(FieldKeys.data, databean.data), new LongField(FieldKeys.expirationMs, databean.expirationMs));
        }
    }

    public static class FieldKeys {
        public static final LongFieldKey size = new LongFieldKey("size");
        public static final ByteArrayFieldKey data = new ByteArrayFieldKey("data").withSize(0xFFFFFF);
        public static final LongFieldKey expirationMs = new LongFieldKey("expirationMs");
    }
}

