/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.config.storage.clusterschemaupdatelock;

import io.datarouter.scanner.Scanner;
import io.datarouter.storage.Datarouter;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.config.PutMethod;
import io.datarouter.storage.config.storage.clusterschemaupdatelock.ClusterSchemaUpdateLock;
import io.datarouter.storage.config.storage.clusterschemaupdatelock.ClusterSchemaUpdateLockKey;
import io.datarouter.storage.dao.BaseDao;
import io.datarouter.storage.dao.BaseDaoParams;
import io.datarouter.storage.node.factory.NodeFactory;
import io.datarouter.storage.node.op.combo.SortedMapStorage;
import io.datarouter.storage.tag.Tag;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DatarouterClusterSchemaUpdateLockDao
extends BaseDao {
    private final SortedMapStorage<ClusterSchemaUpdateLockKey, ClusterSchemaUpdateLock> mainNode;
    private final Optional<SortedMapStorage<ClusterSchemaUpdateLockKey, ClusterSchemaUpdateLock>> optRedundantNode;

    @Inject
    public DatarouterClusterSchemaUpdateLockDao(Datarouter datarouter, NodeFactory nodeFactory, DatarouterClusterSchemaUpdateLockDaoParams params) {
        super(datarouter);
        this.mainNode = (SortedMapStorage)nodeFactory.create(params.clientId, ClusterSchemaUpdateLock::new, ClusterSchemaUpdateLock.ClusterSchemaUpdateLockFielder::new).withTag(Tag.DATAROUTER).buildAndRegister();
        this.optRedundantNode = params.optRedundantClientId.map(clientId -> (SortedMapStorage)nodeFactory.create((ClientId)clientId, ClusterSchemaUpdateLock::new, ClusterSchemaUpdateLock.ClusterSchemaUpdateLockFielder::new).withTag(Tag.DATAROUTER).buildAndRegister());
    }

    public void putAndAcquire(ClusterSchemaUpdateLock databean) {
        Config config = new Config().setPutMethod(PutMethod.INSERT_OR_BUST).setIgnoreException(true);
        this.mainNode.put(databean, config);
        this.optRedundantNode.ifPresent(redundantNode -> redundantNode.put(databean, config));
    }

    public ClusterSchemaUpdateLock get(ClusterSchemaUpdateLockKey key) {
        return (ClusterSchemaUpdateLock)((Object)this.mainNode.get(key));
    }

    public void delete(ClusterSchemaUpdateLockKey key) {
        this.mainNode.delete(key);
        this.optRedundantNode.ifPresent(redundantNode -> redundantNode.delete(key));
    }

    public Scanner<ClusterSchemaUpdateLock> scan() {
        return this.mainNode.scan();
    }

    public static class DatarouterClusterSchemaUpdateLockDaoParams
    extends BaseDaoParams {
        public final Optional<ClientId> optRedundantClientId;

        public DatarouterClusterSchemaUpdateLockDaoParams(List<ClientId> clientIds) {
            super(clientIds.get(0));
            this.optRedundantClientId = clientIds.size() > 1 ? Optional.of(clientIds.get(1)) : Optional.empty();
        }
    }
}

