/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.config.schema;

import io.datarouter.gson.GsonTool;
import org.slf4j.Logger;

public class SchemaUpdateTool {
    private static final int CONSOLE_WIDTH = 80;
    public static final String SINGLE_LINE_SCHEMA_UPDATE_PREFIX = "SchemaUpdate: ";
    private static final String PLEASE_EXECUTE_SCHEMA_UPDATE_MESSAGE = SchemaUpdateTool.generateFullWidthMessage("Please Execute SchemaUpdate");
    private static final String THANK_YOU_MESSAGE = SchemaUpdateTool.generateFullWidthMessage("Thank You");

    public static void printSchemaUpdate(Logger logger, String schemaUpdate) {
        logger.warn(SINGLE_LINE_SCHEMA_UPDATE_PREFIX + GsonTool.withUnregisteredEnums().toJson((Object)schemaUpdate));
        logger.warn(PLEASE_EXECUTE_SCHEMA_UPDATE_MESSAGE);
        logger.warn(schemaUpdate);
        logger.warn(THANK_YOU_MESSAGE);
    }

    public static String generateFullWidthMessage(String message) {
        StringBuilder fullWidthMessage = new StringBuilder();
        int numCharsOnSide = (80 - message.length()) / 2 - 1;
        if (numCharsOnSide <= 0) {
            return message;
        }
        int chars = 0;
        while (chars < numCharsOnSide) {
            fullWidthMessage.append("=");
            ++chars;
        }
        fullWidthMessage.append(" ").append(message).append(" ");
        chars += message.length();
        while (chars < 80) {
            fullWidthMessage.append("=");
            ++chars;
        }
        return fullWidthMessage.toString();
    }
}

