/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.config.schema;

import io.datarouter.storage.config.properties.InternalConfigDirectory;
import io.datarouter.storage.config.schema.SchemaUpdateOptionsFactory;
import io.datarouter.util.properties.PropertiesTool;
import io.datarouter.util.properties.TypedProperties;
import io.datarouter.util.string.StringTool;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SchemaUpdateOptions {
    private static final Logger logger = LoggerFactory.getLogger(SchemaUpdateOptions.class);
    private static final String SCHEMA_UPDATE_FILENAME = "schema-update.properties";
    private static final String SCHEMA_UPDATE = "schemaUpdate";
    public static final String SCHEMA_UPDATE_ENABLE = "schemaUpdate.enable";
    public static final String PRINT_PREFIX = "schemaUpdate.print";
    public static final String EXECUTE_PREFIX = "schemaUpdate.execute";
    public static final String SUFFIX_createDatabases = ".createDatabases";
    public static final String SUFFIX_createTables = ".createTables";
    public static final String SUFFIX_addColumns = ".addColumns";
    public static final String SUFFIX_deleteColumns = ".deleteColumns";
    public static final String SUFFIX_modifyColumns = ".modifyColumns";
    public static final String SUFFIX_addIndexes = ".addIndexes";
    public static final String SUFFIX_dropIndexes = ".dropIndexes";
    public static final String SUFFIX_modifyEngine = ".modifyEngine";
    public static final String SUFFIX_modifyRowFormat = ".modifyRowFormat";
    public static final String SUFFIX_modifyCharacterSetOrCollation = ".modifyCharacterSetOrCollation";
    public static final String SUFFIX_modifyTtl = ".modifyTtl";
    public static final String SUFFIX_modifyMaxVersions = ".modifyMaxVersions";
    public static final List<String> ALL_SCHEMA_UPDATE_OPTIONS = List.of(".createDatabases", ".createTables", ".addColumns", ".deleteColumns", ".modifyColumns", ".addIndexes", ".dropIndexes", ".modifyEngine", ".modifyRowFormat", ".modifyCharacterSetOrCollation", ".modifyTtl", ".modifyMaxVersions");
    protected static final String SUFFIX_ignoreClients = ".ignoreClients";
    protected static final String SUFFIX_ignoreTables = ".ignoreTables";
    private final List<String> ignoreClients;
    private final List<String> ignoreTables;
    private TypedProperties properties;

    @Inject
    public SchemaUpdateOptions(SchemaUpdateOptionsFactory schemaUpdateOptionsFactory, InternalConfigDirectory internalConfigDirectory) {
        Properties propertiesFromClass = schemaUpdateOptionsFactory.getInternalConfigDirectoryTypeSchemaUpdateOptions(internalConfigDirectory.get());
        this.properties = new TypedProperties(List.of(propertiesFromClass));
        if (!this.properties.getUnmodifiablePropertiesList().isEmpty()) {
            logger.warn("Got schema update properties from class {}", (Object)schemaUpdateOptionsFactory.getClass().getCanonicalName());
        } else {
            String configFileLocation = internalConfigDirectory.findConfigFile(SCHEMA_UPDATE_FILENAME);
            try {
                this.properties.addProperties(PropertiesTool.parse((String)configFileLocation));
                logger.warn("Got schema update properties from file {}", (Object)configFileLocation);
            }
            catch (Exception e) {
                logger.warn("Error parsing file {}, using default schema-update options", (Object)configFileLocation, (Object)e);
            }
        }
        String clientsToIgnore = this.properties.getString("schemaUpdate.ignoreClients");
        this.ignoreClients = StringTool.splitOnCharNoRegex((String)clientsToIgnore, (char)',');
        String tablesToIgnore = this.properties.getString("schemaUpdate.ignoreTables");
        this.ignoreTables = StringTool.splitOnCharNoRegex((String)tablesToIgnore, (char)',');
    }

    public boolean getEnabled() {
        return this.isPropertyTrue(SCHEMA_UPDATE_ENABLE).orElse(false);
    }

    public Boolean getCreateDatabases(boolean printVsExecute) {
        return this.isPropertyTrue(printVsExecute, SUFFIX_createDatabases).orElse(true);
    }

    public Boolean getCreateTables(boolean printVsExecute) {
        return this.isPropertyTrue(printVsExecute, SUFFIX_createTables).orElse(true);
    }

    public Boolean getAddColumns(boolean printVsExecute) {
        return this.isPropertyTrue(printVsExecute, SUFFIX_addColumns).orElse(printVsExecute);
    }

    public Boolean getDeleteColumns(boolean printVsExecute) {
        return this.isPropertyTrue(printVsExecute, SUFFIX_deleteColumns).orElse(printVsExecute);
    }

    public Boolean getModifyColumns(boolean printVsExecute) {
        return this.isPropertyTrue(printVsExecute, SUFFIX_modifyColumns).orElse(printVsExecute);
    }

    public Boolean getAddIndexes(boolean printVsExecute) {
        return this.isPropertyTrue(printVsExecute, SUFFIX_addIndexes).orElse(printVsExecute);
    }

    public Boolean getDropIndexes(boolean printVsExecute) {
        return this.isPropertyTrue(printVsExecute, SUFFIX_dropIndexes).orElse(printVsExecute);
    }

    public Boolean getModifyEngine(boolean printVsExecute) {
        return this.isPropertyTrue(printVsExecute, SUFFIX_modifyEngine).orElse(printVsExecute);
    }

    public boolean getModifyCharacterSetOrCollation(boolean printVsExecute) {
        return this.isPropertyTrue(printVsExecute, SUFFIX_modifyCharacterSetOrCollation).orElse(printVsExecute);
    }

    public boolean getModifyRowFormat(boolean printVsExecute) {
        return this.isPropertyTrue(printVsExecute, SUFFIX_modifyRowFormat).orElse(printVsExecute);
    }

    public boolean getModifyTtl(boolean printVsExecute) {
        return this.isPropertyTrue(printVsExecute, SUFFIX_modifyTtl).orElse(printVsExecute);
    }

    public boolean getModifyMaxVersions(boolean printVsExecute) {
        return this.isPropertyTrue(printVsExecute, SUFFIX_modifyMaxVersions).orElse(printVsExecute);
    }

    public boolean getModifyPrimaryKey(boolean printVsExecute) {
        return this.getAddIndexes(printVsExecute) != false && this.getDropIndexes(printVsExecute) != false;
    }

    public List<String> getIgnoreClients() {
        return this.ignoreClients;
    }

    public List<String> getIgnoreTables() {
        return this.ignoreTables;
    }

    private Optional<Boolean> isPropertyTrue(boolean printVsExecute, String suffix) {
        return this.isPropertyTrue(String.valueOf(SchemaUpdateOptions.choosePrefix(printVsExecute)) + suffix);
    }

    private Optional<Boolean> isPropertyTrue(String property) {
        return Optional.ofNullable(this.properties.getBoolean(property));
    }

    private static String choosePrefix(boolean printVsExecute) {
        return printVsExecute ? PRINT_PREFIX : EXECUTE_PREFIX;
    }
}

