/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.config.properties;

import io.datarouter.storage.config.ComputedPropertiesFinder;
import io.datarouter.storage.config.ConfigDirectoryConstants;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class InternalConfigDirectory
implements Supplier<String> {
    public static final String INTERNAL_CONFIG_DIRECTORY = "internalConfigDirectory";
    private final String internalConfigDirectory;

    @Inject
    public InternalConfigDirectory(ComputedPropertiesFinder finder) {
        this.internalConfigDirectory = finder.findProperty(INTERNAL_CONFIG_DIRECTORY);
    }

    @Override
    public String get() {
        return this.internalConfigDirectory;
    }

    public String findConfigFile(String filename) {
        String configDirectory = ConfigDirectoryConstants.getConfigDirectory();
        String externalLocation = String.valueOf(configDirectory) + "/" + filename;
        if (Files.exists(Paths.get(externalLocation, new String[0]), new LinkOption[0])) {
            return externalLocation;
        }
        Objects.requireNonNull(this.internalConfigDirectory, String.valueOf(externalLocation) + " doesn't exist and " + INTERNAL_CONFIG_DIRECTORY + " property is not set");
        externalLocation = String.valueOf(configDirectory) + "/" + this.internalConfigDirectory + "/" + filename;
        if (Files.exists(Paths.get(externalLocation, new String[0]), new LinkOption[0])) {
            return externalLocation;
        }
        return "/config/" + this.internalConfigDirectory + "/" + filename;
    }
}

