/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.config.properties;

import io.datarouter.storage.config.ComputedPropertiesFinder;
import io.datarouter.storage.servertype.ServerType;
import io.datarouter.storage.servertype.ServerTypes;
import java.util.Optional;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DatarouterServerTypeSupplier
implements Supplier<ServerType> {
    public static final String SERVER_TYPE = "server.type";
    private final ServerType serverType;

    @Inject
    public DatarouterServerTypeSupplier(ComputedPropertiesFinder finder, ServerTypes serverTypes) {
        this.serverType = serverTypes.fromPersistentString(finder.findProperty(SERVER_TYPE));
    }

    @Override
    public ServerType get() {
        return this.serverType;
    }

    public String getServerTypeString() {
        return Optional.ofNullable(this.serverType).map(ServerType::getPersistentString).orElse(null);
    }
}

