/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.config;

import io.datarouter.plugin.PluginConfigKey;
import io.datarouter.plugin.PluginConfigType;
import io.datarouter.plugin.PluginInjector;
import io.datarouter.plugin.StringPluginConfigValue;
import io.datarouter.scanner.Scanner;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DatarouterSubscribersSupplier
implements Supplier<Set<String>> {
    public static final PluginConfigKey<StringPluginConfigValue> KEY = new PluginConfigKey("datarouterSubscribers", PluginConfigType.INSTANCE_LIST);
    @Inject
    private PluginInjector injector;

    @Override
    public Set<String> get() {
        List<StringPluginConfigValue> list = this.injector.getInstances(KEY);
        if (list == null) {
            return Set.of();
        }
        return (Set)Scanner.of(list).map(StringPluginConfigValue::getValue).collect(HashSet::new);
    }

    public String getAsCsv() {
        return String.join((CharSequence)",", (Iterable<? extends CharSequence>)this.get());
    }
}

