/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.config;

import io.datarouter.scanner.Scanner;
import io.datarouter.storage.config.DatarouterSubscribersSupplier;
import io.datarouter.storage.config.properties.AdminEmail;
import io.datarouter.storage.config.properties.ConfigDirectory;
import io.datarouter.storage.config.properties.DatarouterEnvironmentTypeSupplier;
import io.datarouter.storage.config.properties.DatarouterServerTypeSupplier;
import io.datarouter.storage.config.properties.EnvironmentDomain;
import io.datarouter.storage.config.properties.EnvironmentName;
import io.datarouter.storage.config.properties.InternalConfigDirectory;
import io.datarouter.storage.config.properties.ServerClusterDomains;
import io.datarouter.storage.config.properties.ServerName;
import io.datarouter.storage.config.properties.ServerPrivateIp;
import io.datarouter.storage.config.properties.ServerPublicIp;
import io.datarouter.storage.config.properties.ServiceName;
import io.datarouter.util.Require;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DatarouterPropertiesService {
    @Inject
    private AdminEmail adminEmail;
    @Inject
    private EnvironmentName environmentName;
    @Inject
    private EnvironmentDomain environmentDomain;
    @Inject
    private DatarouterEnvironmentTypeSupplier environmentType;
    @Inject
    private ServiceName serviceName;
    @Inject
    private InternalConfigDirectory internalConfigDirectory;
    @Inject
    private ServerClusterDomains serverClusterDomains;
    @Inject
    private ServerName serverName;
    @Inject
    private ServerPrivateIp serverPrivateIp;
    @Inject
    private ServerPublicIp serverPublicIp;
    @Inject
    private DatarouterServerTypeSupplier serverType;
    @Inject
    private DatarouterSubscribersSupplier subscribers;
    @Inject
    private ConfigDirectory configDirectory;

    public List<DatarouterProperty> getAllProperties() {
        return Scanner.of((Object[])new DatarouterProperty[]{new DatarouterProperty("administrator.email", this.adminEmail.get()), new DatarouterProperty("environment", this.environmentName.get()), new DatarouterProperty("environmentDomain", this.environmentDomain.get()), new DatarouterProperty("environmentType", this.environmentType.get()), new DatarouterProperty("datarouter.service", this.serviceName.get()), new DatarouterProperty("internalConfigDirectory", this.internalConfigDirectory.get()), new DatarouterProperty("server.clusterDomains", this.serverClusterDomains.get().stream().sorted().collect(Collectors.joining(","))), new DatarouterProperty("server.name", this.serverName.get()), new DatarouterProperty("server.privateIp", this.serverPrivateIp.get()), new DatarouterProperty("server.publicIp", this.serverPublicIp.get()), new DatarouterProperty("server.type", this.serverType.get().getPersistentString()), new DatarouterProperty("subscribers", this.subscribers.get().stream().sorted().collect(Collectors.joining(","))), new DatarouterProperty("configDirectory", this.configDirectory.get())}).sort(Comparator.comparing(DatarouterProperty::key)).list();
    }

    public void assertRequired() {
        Require.notNull((Object)this.adminEmail.get());
        Require.notNull((Object)this.environmentName.get());
        Require.notNull((Object)this.environmentType.get());
        Require.notNull((Object)this.serverName.get());
        Require.notNull((Object)this.serverType.get());
        Require.notNull((Object)this.internalConfigDirectory.get());
    }

    public record DatarouterProperty(String key, String value) {
    }
}

