/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.config;

import io.datarouter.util.string.StringTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigDirectoryConstants {
    private static final Logger logger = LoggerFactory.getLogger(ConfigDirectoryConstants.class);
    public static final String CONFIG_DIRECTORY_NAME = "config";
    public static final String TEST_CONFIG_DIRECTORY_NAME = "test";
    private static final String BASE_CONFIG_DIRECTORY_ENV_VARIABLE = "BASE_CONFIG_DIRECTORY";
    private static final String DEFAULT_BASE_CONFIG_DIRECTORY = "/etc/datarouter";
    private static final String CONFIG_DIRECTORY;
    private static final String TEST_CONFIG_DIRECTORY;
    private static final String SOURCE;

    static {
        String baseConfigDirectory = System.getenv(BASE_CONFIG_DIRECTORY_ENV_VARIABLE);
        if (StringTool.isEmpty((String)baseConfigDirectory)) {
            baseConfigDirectory = DEFAULT_BASE_CONFIG_DIRECTORY;
            SOURCE = "default constant";
        } else {
            SOURCE = "environment variable";
        }
        CONFIG_DIRECTORY = String.valueOf(baseConfigDirectory) + "/" + CONFIG_DIRECTORY_NAME;
        TEST_CONFIG_DIRECTORY = String.valueOf(baseConfigDirectory) + "/" + TEST_CONFIG_DIRECTORY_NAME;
    }

    public static String getSource() {
        logger.info("source={}", (Object)SOURCE);
        return SOURCE;
    }

    public static String getConfigDirectory() {
        logger.info("configDirectory={}", (Object)CONFIG_DIRECTORY);
        return CONFIG_DIRECTORY;
    }

    public static String getTestConfigDirectory() {
        logger.info("testConfigDirectory={}", (Object)TEST_CONFIG_DIRECTORY);
        return TEST_CONFIG_DIRECTORY;
    }
}

