/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.config;

import io.datarouter.storage.config.ConfigKey;
import io.datarouter.storage.config.ConfigValue;
import io.datarouter.storage.config.PutMethod;
import io.datarouter.util.Require;
import io.datarouter.util.lang.LineOfCode;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class Config
implements Cloneable {
    public static final int DEFAULT_REQUEST_BATCH_SIZE = 100;
    public static final int DEFAULT_RESPONSE_BATCH_SIZE = 100;
    private Boolean useSession = true;
    private Boolean anyDelay = false;
    private PutMethod putMethod = PutMethod.DEFAULT_PUT_METHOD;
    private Boolean persistentPut = true;
    private Boolean scannerPrefetching;
    private Boolean scannerCaching;
    private Boolean allowUnsortedScan;
    private Integer requestBatchSize;
    private Integer responseBatchSize;
    private Boolean ignoreException;
    private Duration timeout;
    private Integer numAttempts;
    private Integer limit;
    private Integer offset;
    private Duration ttl;
    private Long visibilityTimeoutMs;
    private LineOfCode callsite;
    private LineOfCode customCallsite;
    private final Map<ConfigKey<?>, ConfigValue<?>> configuration = new HashMap();

    public Config addOption(ConfigValue<?> option) {
        this.configuration.put(option.getKey(), option);
        return this;
    }

    public final <T extends ConfigValue<T>> Optional<T> getOption(ConfigKey<T> key) {
        return Optional.ofNullable(this.configuration.get(key));
    }

    public Config clone() {
        return this.getDeepCopy();
    }

    public Config getDeepCopy() {
        Config clone = new Config();
        clone.setUseSession(this.useSession).setAnyDelay(this.anyDelay).setPutMethod(this.putMethod).setPersistentPut(this.persistentPut).setScannerCaching(this.scannerCaching).setAllowUnsortedScan(this.allowUnsortedScan).setRequestBatchSize(this.requestBatchSize).setResponseBatchSize(this.responseBatchSize).setIgnoreException(this.ignoreException).setTimeout(this.timeout).setNumAttempts(this.numAttempts).setLimit(this.limit).setOffset(this.offset).setTtl(this.ttl).setVisibilityTimeoutMs(this.visibilityTimeoutMs).setCallsite(this.callsite).setCustomCallsite(this.customCallsite);
        this.configuration.values().forEach(clone::addOption);
        return clone;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Optional<Integer> findLimit() {
        return Optional.ofNullable(this.limit);
    }

    public Config setLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public Optional<Integer> findOffset() {
        return Optional.ofNullable(this.offset);
    }

    public Config setOffset(Integer offset) {
        this.offset = offset;
        return this;
    }

    public Optional<Integer> findRequestBatchSize() {
        return Optional.ofNullable(this.requestBatchSize);
    }

    public Config setRequestBatchSize(Integer requestBatchSize) {
        Require.isTrue((requestBatchSize == null || requestBatchSize > 0 ? 1 : 0) != 0);
        this.requestBatchSize = requestBatchSize;
        return this;
    }

    public Optional<Integer> findResponseBatchSize() {
        return Optional.ofNullable(this.responseBatchSize);
    }

    public Config setResponseBatchSize(Integer responseBatchSize) {
        Require.isTrue((responseBatchSize == null || responseBatchSize > 0 ? 1 : 0) != 0);
        this.responseBatchSize = responseBatchSize;
        return this;
    }

    public Boolean getAnyDelay() {
        return this.anyDelay;
    }

    public Config setAnyDelay(boolean anyDelay) {
        this.anyDelay = anyDelay;
        return this;
    }

    public Config anyDelay() {
        return this.setAnyDelay(true);
    }

    public Boolean getUseSession() {
        return this.useSession;
    }

    public Config setUseSession(Boolean useSession) {
        this.useSession = useSession;
        return this;
    }

    public Integer getNumAttempts() {
        return this.numAttempts;
    }

    public Integer getNumAttemptsOrUse(int alternative) {
        if (this.numAttempts != null) {
            return this.numAttempts;
        }
        return alternative;
    }

    public Config setNumAttempts(Integer numAttempts) {
        this.numAttempts = numAttempts;
        return this;
    }

    public Optional<Duration> findTimeout() {
        return Optional.ofNullable(this.timeout);
    }

    public Config setTimeout(Duration duration) {
        this.timeout = duration;
        return this;
    }

    public Config setNoTimeout() {
        this.setTimeout(Duration.ofMillis(Long.MAX_VALUE));
        return this;
    }

    public PutMethod getPutMethod() {
        return this.putMethod;
    }

    public Config setPutMethod(PutMethod putMethod) {
        this.putMethod = putMethod;
        return this;
    }

    public Optional<Boolean> findScannerPrefetching() {
        return Optional.ofNullable(this.scannerPrefetching);
    }

    public Config setScannerPrefetching(Boolean scannerPrefetching) {
        this.scannerPrefetching = scannerPrefetching;
        return this;
    }

    public Optional<Boolean> findScannerCaching() {
        return Optional.ofNullable(this.scannerCaching);
    }

    public Config setScannerCaching(Boolean scannerCaching) {
        this.scannerCaching = scannerCaching;
        return this;
    }

    public Optional<Boolean> findAllowUnsortedScan() {
        return Optional.ofNullable(this.allowUnsortedScan);
    }

    public Config setAllowUnsortedScan(Boolean allowUnsortedScan) {
        this.allowUnsortedScan = allowUnsortedScan;
        return this;
    }

    public Boolean getPersistentPut() {
        return this.persistentPut;
    }

    public Config setPersistentPut(Boolean persistentPut) {
        this.persistentPut = persistentPut;
        return this;
    }

    public Optional<Duration> findTtl() {
        return Optional.ofNullable(this.ttl);
    }

    public Config setTtl(Duration ttl) {
        this.ttl = ttl;
        return this;
    }

    public long getVisibilityTimeoutMsOrUse(long alternative) {
        if (this.visibilityTimeoutMs != null) {
            return this.visibilityTimeoutMs;
        }
        return alternative;
    }

    public Long getVisibilityTimeoutMs() {
        return this.visibilityTimeoutMs;
    }

    public Config setVisibilityTimeoutMs(Long visibilityTimeoutMs) {
        this.visibilityTimeoutMs = visibilityTimeoutMs;
        return this;
    }

    public LineOfCode getCallsite() {
        return this.callsite;
    }

    public Config setCallsite(LineOfCode callsite) {
        this.callsite = callsite;
        return this;
    }

    public LineOfCode getCustomCallsite() {
        return this.customCallsite;
    }

    public Config setCustomCallsite(LineOfCode customCallsite) {
        this.customCallsite = customCallsite;
        return this;
    }

    public Config setIgnoreException(Boolean paramIgnoreException) {
        this.ignoreException = paramIgnoreException;
        return this;
    }

    public Optional<Boolean> findIgnoreException() {
        return Optional.ofNullable(this.ignoreException);
    }
}

