/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.config;

import io.datarouter.scanner.Scanner;
import io.datarouter.storage.config.ConfigDirectoryConstants;
import io.datarouter.util.Require;
import io.datarouter.util.io.FileTool;
import io.datarouter.util.properties.PropertiesTool;
import io.datarouter.util.string.StringTool;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ComputedPropertiesFinder {
    private static final Logger logger = LoggerFactory.getLogger(ComputedPropertiesFinder.class);
    public static final String JVM_ARG_PREFIX = "datarouter.";
    private static final String CONFIG_DIRECTORY_PROP = "config.directory";
    public static final String SERVER_CONFIG_FILE_NAME = "server.properties";
    private static final boolean SHOW_LOGGER = false;
    private final String configDirectory;
    private final String configFileLocation;
    private Optional<Properties> propertiesFromConfigFile = Optional.empty();

    public ComputedPropertiesFinder() {
        this(ConfigDirectoryConstants.getConfigDirectory(), true, false, SERVER_CONFIG_FILE_NAME, true);
    }

    private ComputedPropertiesFinder(String configDirectory, boolean directoryRequired, boolean directoryFromJvmArg, String filename, boolean fileRequired) {
        boolean fileRequiredWithoutDirectoryRequired = fileRequired && !directoryRequired;
        Require.isTrue((!fileRequiredWithoutDirectoryRequired ? 1 : 0) != 0, (String)"directory is required if file is required");
        this.configDirectory = this.validateConfigDirectory(configDirectory, directoryRequired, directoryFromJvmArg);
        this.configFileLocation = this.findConfigFileLocation(filename, fileRequired);
    }

    public String validateConfigDirectory(String configDirectory, boolean directoryRequired, boolean directoryFromJvmArg) {
        if (configDirectory != null) {
            FileTool.createFileParents((String)(String.valueOf(configDirectory) + "/anything"));
            if (directoryFromJvmArg) {
                this.logJvmArgSource(CONFIG_DIRECTORY_PROP, configDirectory, "datarouter.config.directory");
            } else {
                this.logSource("config directory", configDirectory, ConfigDirectoryConstants.getSource());
            }
        } else {
            Require.isTrue((!directoryRequired ? 1 : 0) != 0, (String)"config directory required but not found");
        }
        return configDirectory;
    }

    public String findConfigFileLocation(String filename, boolean fileRequired) {
        String configFileLocation = null;
        if (StringTool.isEmpty((String)filename)) {
            Require.isTrue((!fileRequired ? 1 : 0) != 0);
        } else {
            configFileLocation = String.valueOf(this.configDirectory) + "/" + filename;
            if (Files.notExists(Paths.get(configFileLocation, new String[0]), new LinkOption[0])) {
                logger.error("couldn't find config file {}", (Object)configFileLocation);
            } else {
                logger.warn("found config file {}", (Object)configFileLocation);
                try {
                    this.propertiesFromConfigFile = Optional.of(PropertiesTool.parse((String)configFileLocation));
                    this.logConfigFileProperties();
                }
                catch (Exception e) {
                    logger.error("couldn't parse config file {}", (Object)configFileLocation);
                }
            }
        }
        return configFileLocation;
    }

    public String findProperty(String propertyName) {
        return this.findProperty(propertyName, List.of());
    }

    public String findProperty(String propertyName, Supplier<String> defaultValue) {
        return this.findProperty(propertyName, List.of(new FallbackPropertyValueSupplierDto(defaultValue)));
    }

    public String findProperty(String propertyName, Supplier<String> defaultValueSupplier, String defaultSource) {
        return this.findProperty(propertyName, List.of(new FallbackPropertyValueSupplierDto(defaultSource, defaultValueSupplier)));
    }

    public String findProperty(String propertyName, List<FallbackPropertyValueSupplierDto> defaultValueSupplierDtos) {
        Optional<PropertyValueBySource> propertyValueBySource = this.getPropFromJvmArg(propertyName).or(() -> this.getPropFromConfigFile(propertyName)).or(() -> this.getPropFromDefaults(propertyName, defaultValueSupplierDtos));
        if (propertyValueBySource.isPresent() && !propertyValueBySource.get().value().isEmpty()) {
            return propertyValueBySource.get().value();
        }
        if (propertyValueBySource.isPresent()) {
            logger.info("found {} with empty value from {}", (Object)propertyName, (Object)propertyValueBySource.get().source());
        } else {
            logger.info("couldn't find " + propertyName + ", no default provided");
        }
        return null;
    }

    private Optional<PropertyValueBySource> getPropFromConfigFile(String propertyName) {
        Optional<String> propertyValue = this.propertiesFromConfigFile.map(properties -> properties.getProperty(propertyName));
        if (propertyValue.isEmpty()) {
            return Optional.empty();
        }
        if (!propertyValue.get().isEmpty()) {
            this.logSource(propertyName, propertyValue.get(), this.configFileLocation);
        }
        return Optional.of(new PropertyValueBySource(propertyValue.get(), this.configFileLocation));
    }

    private Optional<PropertyValueBySource> getPropFromJvmArg(String jvmArg) {
        String jvmArgName = JVM_ARG_PREFIX + jvmArg;
        String jvmArgValue = System.getProperty(jvmArgName);
        if (jvmArgValue == null) {
            return Optional.empty();
        }
        if (!jvmArgValue.isEmpty()) {
            this.logJvmArgSource(jvmArg, jvmArgValue, jvmArgName);
        }
        return Optional.of(new PropertyValueBySource(jvmArgValue, jvmArgName));
    }

    private Optional<PropertyValueBySource> getPropFromDefaults(String propertyName, List<FallbackPropertyValueSupplierDto> defaultValueSupplierDtos) {
        Optional<PropertyValueBySource> optionalValueAndSource = defaultValueSupplierDtos.stream().map(dto -> new PropertyValueBySource(dto.fallbackSupplier.get(), dto.propertySource)).filter(valueAndSource -> valueAndSource.value() != null).findFirst();
        if (optionalValueAndSource.isPresent()) {
            PropertyValueBySource valueAndSource2 = optionalValueAndSource.get();
            this.logSource(propertyName, valueAndSource2.value(), valueAndSource2.source());
            return optionalValueAndSource;
        }
        return Optional.empty();
    }

    private void logConfigFileProperties() {
        Properties allProperties = this.propertiesFromConfigFile.orElseGet(Properties::new);
        Scanner.of(allProperties.stringPropertyNames()).map(name -> String.valueOf(name) + "=" + allProperties.getProperty((String)name)).sort().forEach(arg_0 -> ((Logger)logger).info(arg_0));
    }

    private void logSource(String name, String value, String source) {
        logger.info("found {}={} from {}", new Object[]{name, value, source});
    }

    private void logJvmArgSource(String name, String value, String jvmArgName) {
        logger.info("found {}={} from -D{} JVM arg", new Object[]{name, value, jvmArgName});
    }

    public List<String> findPropertyStringsSplitWithComma(String propertyName) {
        String propertyValue = this.findProperty(propertyName);
        if (StringTool.isNullOrEmptyOrWhitespace((String)propertyValue)) {
            return List.of();
        }
        return Scanner.of((Object[])propertyValue.split(",")).include(StringTool::notEmptyNorWhitespace).map(String::trim).list();
    }

    public static class FallbackPropertyValueSupplierDto {
        public final String propertySource;
        public final Supplier<String> fallbackSupplier;

        public FallbackPropertyValueSupplierDto(Supplier<String> fallbackSupplier) {
            this("default", fallbackSupplier);
        }

        public FallbackPropertyValueSupplierDto(String propertySource, Supplier<String> fallbackSupplier) {
            Require.notNull(fallbackSupplier);
            Require.isTrue((boolean)StringTool.notNullNorEmptyNorWhitespace((String)propertySource));
            this.propertySource = propertySource;
            this.fallbackSupplier = fallbackSupplier;
        }
    }

    private record PropertyValueBySource(String value, String source) {
    }
}

