/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.config;

import com.google.inject.Module;
import io.datarouter.inject.guice.BasePlugin;
import io.datarouter.plugin.PluginConfigKey;
import io.datarouter.plugin.PluginConfigValue;
import io.datarouter.storage.dao.Dao;
import io.datarouter.storage.dao.DaosModuleBuilder;
import io.datarouter.storage.setting.SettingRoot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BaseStoragePlugin
extends BasePlugin {
    private DaosModuleBuilder daosModule = new DaosModuleBuilder.SimpleDaosModule();
    private final List<BaseStoragePlugin> storagePlugins = new ArrayList<BaseStoragePlugin>();
    private final List<Module> testModules = new ArrayList<Module>();
    public final Map<PluginConfigKey<?>, Class<? extends PluginConfigValue<?>>> classSingle = new HashMap();
    public final Map<PluginConfigKey<?>, List<Class<? extends PluginConfigValue<?>>>> classList = new HashMap();
    public final Map<PluginConfigKey<?>, PluginConfigValue<?>> instanceSingle = new HashMap();
    public final Map<PluginConfigKey<?>, List<PluginConfigValue<?>>> instanceList = new HashMap();

    protected void addSettingRoot(Class<? extends SettingRoot> settingRoot) {
        this.addPluginEntry(SettingRoot.KEY, settingRoot);
    }

    protected void setDaosModule(DaosModuleBuilder daosModule) {
        this.daosModule = daosModule;
    }

    public DaosModuleBuilder getDaosModuleBuilder() {
        return this.daosModule;
    }

    protected void setDaos(Class<? extends Dao> ... daos) {
        DaosModuleBuilder.SimpleDaosModule daosModule = new DaosModuleBuilder.SimpleDaosModule(daos);
        this.setDaosModule(daosModule);
    }

    protected void addStoragePlugin(BaseStoragePlugin storagePlugin) {
        this.storagePlugins.add(storagePlugin);
    }

    public List<BaseStoragePlugin> getStoragePlugins() {
        return this.storagePlugins;
    }

    protected void addTestModule(Module testModule) {
        this.testModules.add(testModule);
    }

    public List<Module> getTestModules() {
        return this.testModules;
    }

    public void addPluginConfig(Map<PluginConfigKey<?>, List<Class<? extends PluginConfigValue<?>>>> map) {
        map.forEach(this::addPluginEntries);
    }

    protected void addPluginEntries(PluginConfigKey<?> key, Collection<Class<? extends PluginConfigValue<?>>> values) {
        values.forEach(value -> this.addPluginEntryInternal(key, (Class<? extends PluginConfigValue<?>>)value));
    }

    protected void addPluginEntries(Collection<PluginConfigValue<?>> values) {
        values.forEach(this::addPluginEntryInternal);
    }

    protected void addPluginEntry(PluginConfigKey<?> key, Class<? extends PluginConfigValue<?>> value) {
        this.addPluginEntryInternal(key, value);
    }

    protected void addPluginEntry(PluginConfigValue<?> value) {
        this.addPluginEntryInternal(value);
    }

    private void addPluginEntryInternal(PluginConfigKey<?> key, Class<? extends PluginConfigValue<?>> value) {
        switch (key.type) {
            case CLASS_LIST: {
                this.classList.computeIfAbsent(key, $ -> new ArrayList()).add(value);
                break;
            }
            case CLASS_SINGLE: {
                if (this.classSingle.containsKey(key)) {
                    throw new RuntimeException(String.valueOf(key.persistentString) + " has already been set");
                }
                this.classSingle.put(key, value);
                break;
            }
        }
    }

    private void addPluginEntryInternal(PluginConfigValue<?> value) {
        switch (value.getKey().type) {
            case INSTANCE_LIST: {
                this.instanceList.computeIfAbsent(value.getKey(), $ -> new ArrayList()).add(value);
                break;
            }
            case INSTANCE_SINGLE: {
                if (this.instanceSingle.containsKey(value.getKey())) {
                    throw new RuntimeException(String.valueOf(value.getKey().persistentString) + " has already been set");
                }
                this.instanceSingle.put(value.getKey(), value);
                break;
            }
        }
    }
}

