/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.client;

import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientOptionsBuilder;
import io.datarouter.util.Require;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.inject.Singleton;

public interface ClientOptionsFactory {
    public Properties getInternalConfigDirectoryTypeOptions(String var1);

    default public Properties mergeOptions(Properties ... options) {
        Properties merged = new Properties();
        Scanner.of((Object[])options).each(props -> props.keySet().forEach(key -> Require.isFalse((boolean)merged.containsKey(key), (String)("duplicate key " + key)))).forEach(merged::putAll);
        return merged;
    }

    default public Properties mergeBuilders(Collection<ClientOptionsBuilder> builders) {
        Properties[] multiProperties = (Properties[])builders.stream().map(ClientOptionsBuilder::build).toArray(Properties[]::new);
        return this.mergeOptions(multiProperties);
    }

    default public Properties mergeBuilders(ClientOptionsBuilder ... builders) {
        return this.mergeBuilders(List.of(builders));
    }

    default public Properties mergeBuilders(Collection<ClientOptionsBuilder> builderCollection, ClientOptionsBuilder ... builderVarargs) {
        return (Properties)Scanner.of((Object[])new Collection[]{builderCollection, List.of(builderVarargs)}).concat(Scanner::of).listTo(this::mergeBuilders);
    }

    @Singleton
    public static class NoOpClientOptionsFactory
    implements ClientOptionsFactory {
        @Override
        public Properties getInternalConfigDirectoryTypeOptions(String internalConfigDirectoryTypeName) {
            return new Properties();
        }
    }
}

