/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.plugin;

import io.datarouter.inject.DatarouterInjector;
import io.datarouter.plugin.PluginConfigKey;
import io.datarouter.plugin.PluginConfigType;
import io.datarouter.plugin.PluginConfigValue;
import io.datarouter.plugin.PluginConfiguration;
import io.datarouter.scanner.Scanner;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class PluginInjector {
    @Inject
    private PluginConfiguration pluginConfiguration;
    @Inject
    private DatarouterInjector datarouterInjector;

    public <T extends PluginConfigValue<T>> T getInstance(PluginConfigKey<T> key) {
        if (key.type == PluginConfigType.INSTANCE_SINGLE) {
            return (T)((PluginConfigValue)this.pluginConfiguration.findInstanceSingle(key).orElse(null));
        }
        if (key.type == PluginConfigType.CLASS_SINGLE) {
            Optional<Class<T>> clazz = this.pluginConfiguration.findClassSingle(key);
            if (clazz.isEmpty()) {
                return null;
            }
            return (T)((PluginConfigValue)this.datarouterInjector.getInstance(clazz.get()));
        }
        return null;
    }

    public <T extends PluginConfigValue<T>> List<T> getInstances(PluginConfigKey<T> key) {
        if (key.type == PluginConfigType.INSTANCE_LIST) {
            Optional<List<T>> list = this.pluginConfiguration.findInstanceList(key);
            if (list.isEmpty()) {
                return List.of();
            }
            return list.get();
        }
        if (key.type == PluginConfigType.CLASS_LIST) {
            Optional<List<Class<T>>> list = this.pluginConfiguration.findClassList(key);
            if (list.isEmpty()) {
                return List.of();
            }
            return Scanner.of((Iterable)list.get()).map(arg_0 -> ((DatarouterInjector)this.datarouterInjector).getInstance(arg_0)).list();
        }
        return null;
    }

    public <T extends PluginConfigValue<T>> Scanner<T> scanInstances(PluginConfigKey<T> key) {
        return Scanner.of(this.getInstances(key));
    }
}

