/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.plugin;

import io.datarouter.plugin.PluginConfigKey;
import io.datarouter.plugin.PluginConfigValue;
import io.datarouter.scanner.Scanner;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Singleton;

@Singleton
public class PluginConfiguration {
    private final Map<PluginConfigKey<?>, Class<? extends PluginConfigValue<?>>> classSingle;
    private final Map<PluginConfigKey<?>, List<Class<? extends PluginConfigValue<?>>>> classList;
    private final Map<PluginConfigKey<?>, PluginConfigValue<?>> instanceSingle;
    private final Map<PluginConfigKey<?>, List<PluginConfigValue<?>>> instanceList;

    public PluginConfiguration(Map<PluginConfigKey<?>, Class<? extends PluginConfigValue<?>>> classSingle, Map<PluginConfigKey<?>, List<Class<? extends PluginConfigValue<?>>>> classList, Map<PluginConfigKey<?>, PluginConfigValue<?>> instanceSingle, Map<PluginConfigKey<?>, List<PluginConfigValue<?>>> instanceList) {
        this.classSingle = classSingle;
        this.classList = classList;
        this.instanceSingle = instanceSingle;
        this.instanceList = instanceList;
    }

    public <T extends PluginConfigValue<T>> Optional<List<Class<T>>> findClassList(PluginConfigKey<T> key) {
        List<Class<? extends PluginConfigValue<?>>> clazzes = this.classList.get(key);
        if (clazzes == null) {
            return Optional.empty();
        }
        List list = Scanner.of(clazzes).map(clazz -> clazz).list();
        return Optional.ofNullable(list);
    }

    public <T extends PluginConfigValue<T>> Optional<Class<T>> findClassSingle(PluginConfigKey<T> key) {
        Class<? extends PluginConfigValue<?>> clazz = this.classSingle.get(key);
        return Optional.ofNullable(clazz);
    }

    public <T extends PluginConfigValue<T>> Optional<List<T>> findInstanceList(PluginConfigKey<T> key) {
        List<PluginConfigValue<?>> clazzes = this.instanceList.get(key);
        return Optional.ofNullable(clazzes);
    }

    public <T extends PluginConfigValue<T>> Optional<T> findInstanceSingle(PluginConfigKey<T> key) {
        return Optional.ofNullable(this.instanceSingle.get(key));
    }
}

