/*
 * Copyright © 2009 HotPads (admin@hotpads.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.datarouter.storage.node.factory;

import java.util.function.Supplier;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.databean.FieldlessIndexEntry;
import io.datarouter.model.field.FieldlessIndexEntryFielder;
import io.datarouter.model.index.unique.UniqueIndexEntry;
import io.datarouter.model.key.FieldlessIndexEntryPrimaryKey;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.client.imp.NoTxnManagedUniqueIndexNode;
import io.datarouter.storage.client.imp.TxnManagedUniqueIndexNode;
import io.datarouter.storage.node.builder.ManagedNodeBuilder;
import io.datarouter.storage.node.op.combo.IndexedMapStorage;
import io.datarouter.storage.node.op.combo.IndexedMapStorage.IndexedMapStorageNode;
import io.datarouter.storage.node.type.index.ManagedUniqueIndexNode;
import io.datarouter.storage.serialize.fieldcache.IndexEntryFieldInfo;

public class IndexingNodeFactory extends BaseNodeFactory{

	/**
	 * WARNING: make sure the index fielder you pass in has the same character set and collation options as the backing
	 * node's fielder or risk having incorrect, performance-hurting introducers in SQL
	 */
	public static <
			PK extends PrimaryKey<PK>,
			D extends Databean<PK,D>,
			IK extends PrimaryKey<IK>,
			IE extends UniqueIndexEntry<IK,IE,PK,D>,
			IF extends DatabeanFielder<IK,IE>>
	ManagedUniqueIndexNode<PK,D,IK,IE,IF> newManagedUnique(
			IndexedMapStorage<PK, D> backingNode,
			Supplier<IF> indexFielderSupplier,
			Supplier<IE> indexEntrySupplier,
			boolean manageTxn,
			String indexName){
		IndexEntryFieldInfo<IK,IE,IF> fieldInfo = new IndexEntryFieldInfo<>(indexName, indexEntrySupplier,
				indexFielderSupplier);
		if(manageTxn){
			return new TxnManagedUniqueIndexNode<>(backingNode, fieldInfo, indexName);
		}
		return new NoTxnManagedUniqueIndexNode<>(backingNode, fieldInfo, indexName);
	}

	/**
	 * WARNING: make sure the index fielder you pass in has the same character set and collation options as the backing
	 * node's fielder or risk having incorrect, performance-hurting introducers in SQL
	 */
	public static <
			PK extends PrimaryKey<PK>,
			D extends Databean<PK,D>,
			IK extends PrimaryKey<IK>,
			IE extends UniqueIndexEntry<IK,IE,PK,D>,
			IF extends DatabeanFielder<IK,IE>>
	ManagedUniqueIndexNode<PK,D,IK,IE,IF> newManagedUnique(
			IndexedMapStorage<PK, D> backingNode,
			Supplier<IF> indexFielderSupplier,
			Supplier<IE> indexEntrySupplier,
			boolean manageTxn){
		return newManagedUnique(
				backingNode,
				indexFielderSupplier,
				indexEntrySupplier,
				manageTxn,
				indexEntrySupplier.get().getClass().getSimpleName());
	}

	public <PK extends PrimaryKey<PK>,
			D extends Databean<PK,D>,
			F extends DatabeanFielder<PK,D>,
			IK extends FieldlessIndexEntryPrimaryKey<IK,PK,D>>
	ManagedNodeBuilder<PK,D,IK,FieldlessIndexEntry<IK,PK,D>,FieldlessIndexEntryFielder<IK,PK,D>>
	createKeyOnlyManagedIndex(
			Supplier<IK> indexEntryKeySupplier,
			IndexedMapStorageNode<PK,D,F> backingNode){
	return new ManagedNodeBuilder<>(
			indexEntryKeySupplier,
			() -> new FieldlessIndexEntry<>(indexEntryKeySupplier),
			() -> new FieldlessIndexEntryFielder<>(
					indexEntryKeySupplier,
					backingNode.getFieldInfo().getSampleFielder()),
			backingNode);
	}

}
