/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.secretweb.storage.oprecord;

import io.datarouter.inject.DatarouterInjector;
import io.datarouter.model.databean.Databean;
import io.datarouter.scanner.Scanner;
import io.datarouter.secret.op.SecretOpInfo;
import io.datarouter.secret.service.SecretOpRecorder;
import io.datarouter.secret.service.SecretOpRecorderSupplier;
import io.datarouter.secretweb.storage.oprecord.DatarouterSecretOpRecord;
import io.datarouter.secretweb.storage.oprecord.DatarouterSecretOpRecordKey;
import io.datarouter.storage.Datarouter;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.dao.BaseDao;
import io.datarouter.storage.dao.BaseRedundantDaoParams;
import io.datarouter.storage.node.factory.NodeFactory;
import io.datarouter.storage.node.op.combo.SortedMapStorage;
import io.datarouter.util.string.StringTool;
import io.datarouter.virtualnode.redundant.RedundantSortedMapStorageNode;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DatarouterSecretOpRecordDao
extends BaseDao
implements SecretOpRecorder {
    private static final Logger logger = LoggerFactory.getLogger(DatarouterSecretOpRecordDao.class);
    private final SortedMapStorage.SortedMapStorageNode<DatarouterSecretOpRecordKey, DatarouterSecretOpRecord, DatarouterSecretOpRecord.DatarouterSecretOpRecordFielder> node;

    @Inject
    public DatarouterSecretOpRecordDao(Datarouter datarouter, NodeFactory nodeFactory, DatarouterSecretOpRecordDaoParams params) {
        super(datarouter);
        this.node = (SortedMapStorage.SortedMapStorageNode)Scanner.of((Iterable)params.clientIds).map(clientId -> {
            SortedMapStorage.SortedMapStorageNode node = (SortedMapStorage.SortedMapStorageNode)nodeFactory.create(clientId, DatarouterSecretOpRecord::new, DatarouterSecretOpRecord.DatarouterSecretOpRecordFielder::new).withIsSystemTable(true).build();
            return node;
        }).listTo(RedundantSortedMapStorageNode::new);
        datarouter.register(this.node);
    }

    public void recordOp(SecretOpInfo<?, ?> opInfo) {
        String reasonString = opInfo.reason.toString();
        if (reasonString.length() > 255) {
            logger.warn("SecretOpReason too long: {}. Max length={}", (Object)reasonString, (Object)255);
            reasonString = StringTool.trimToSize((String)reasonString, (int)255);
        }
        this.node.put((Databean)new DatarouterSecretOpRecord(opInfo.namespace, opInfo.name, opInfo.clientOp.getOpType(), opInfo.reason.type, reasonString));
    }

    @Singleton
    public static class DaoSecretOpRecorderSupplier
    implements SecretOpRecorderSupplier {
        @Inject
        private DatarouterInjector injector;

        public SecretOpRecorder get() {
            return (SecretOpRecorder)this.injector.getInstance(DatarouterSecretOpRecordDao.class);
        }
    }

    public static class DatarouterSecretOpRecordDaoParams
    extends BaseRedundantDaoParams {
        public DatarouterSecretOpRecordDaoParams(List<ClientId> clientId) {
            super(clientId);
        }
    }
}

