/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.secretweb.config;

import com.google.inject.Module;
import io.datarouter.secret.config.DatarouterSecretPlugin;
import io.datarouter.secretweb.config.DatarouterSecretPaths;
import io.datarouter.secretweb.config.DatarouterSecretRouteSet;
import io.datarouter.secretweb.service.DatarouterPropertiesAndServiceSecretNamespacer;
import io.datarouter.secretweb.service.DatarouterPropertiesLocalStorageConfig;
import io.datarouter.secretweb.service.DefaultHandlerSerializer;
import io.datarouter.secretweb.service.ServerTypeDetectorSecretStageDetector;
import io.datarouter.secretweb.storage.oprecord.DatarouterSecretOpRecordDao;
import io.datarouter.secretweb.web.DefaultSecretHandlerPermissions;
import io.datarouter.secretweb.web.SecretHandlerPermissions;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.dao.Dao;
import io.datarouter.storage.dao.DaosModuleBuilder;
import io.datarouter.web.config.BaseWebPlugin;
import io.datarouter.web.navigation.DatarouterNavBarCategory;
import io.datarouter.web.navigation.NavBarCategory;
import java.util.List;

public class DatarouterSecretWebPlugin
extends BaseWebPlugin {
    private final DatarouterSecretPlugin basePlugin;
    private final Class<? extends SecretHandlerPermissions> secretHandlerPermissions;

    private DatarouterSecretWebPlugin(DatarouterSecretPlugin basePlugin, Class<? extends SecretHandlerPermissions> secretHandlerPermissions, DatarouterSecretDaoModule daosModuleBuilder) {
        this.basePlugin = basePlugin;
        this.secretHandlerPermissions = secretHandlerPermissions;
        this.addRouteSet(DatarouterSecretRouteSet.class);
        this.setDaosModule(daosModuleBuilder);
        this.addDatarouterNavBarItem((NavBarCategory)DatarouterNavBarCategory.KEYS, new DatarouterSecretPaths().datarouter.secrets, "Secrets");
        this.addDatarouterGithubDocLink("datarouter-secrets-web");
    }

    public String getName() {
        return "DatarouterSecret";
    }

    public void configure() {
        this.install((Module)this.basePlugin);
        this.bindActual(SecretHandlerPermissions.class, this.secretHandlerPermissions);
    }

    public static class DatarouterSecretDaoModule
    extends DaosModuleBuilder {
        private final ClientId datarouterSecretOpRecordDaoClientId;

        public DatarouterSecretDaoModule(ClientId datarouterSecretOpRecordDaoClientId) {
            this.datarouterSecretOpRecordDaoClientId = datarouterSecretOpRecordDaoClientId;
        }

        public List<Class<? extends Dao>> getDaoClasses() {
            return List.of(DatarouterSecretOpRecordDao.class);
        }

        public void configure() {
            this.bind(DatarouterSecretOpRecordDao.DatarouterSecretOpRecordDaoParams.class).toInstance((Object)new DatarouterSecretOpRecordDao.DatarouterSecretOpRecordDaoParams(this.datarouterSecretOpRecordDaoClientId));
        }
    }

    public static abstract class DatarouterSecretWebPluginBuilder<T extends DatarouterSecretWebPluginBuilder<T>>
    extends DatarouterSecretPlugin.DatarouterSecretPluginBuilder<T> {
        private final ClientId defaultClientId;
        private Class<? extends SecretHandlerPermissions> secretHandlerPermissions = DefaultSecretHandlerPermissions.class;

        public DatarouterSecretWebPluginBuilder(ClientId defaultClientId) {
            this.defaultClientId = defaultClientId;
            this.setSecretNamespacer(DatarouterPropertiesAndServiceSecretNamespacer.class);
            this.setSecretStageDetector(ServerTypeDetectorSecretStageDetector.class);
            this.setSecretOpRecorderSupplier(DatarouterSecretOpRecordDao.DaoSecretOpRecorderSupplier.class);
            this.setLocalStorageConfig(DatarouterPropertiesLocalStorageConfig.class);
            this.setJsonSerializer(DefaultHandlerSerializer.class);
        }

        public T setSecretHandlerPermissions(Class<? extends SecretHandlerPermissions> secretHandlerPermissions) {
            this.secretHandlerPermissions = secretHandlerPermissions;
            return (T)((Object)((DatarouterSecretWebPluginBuilder)this.getSelf()));
        }

        protected DatarouterSecretWebPlugin getWebPlugin() {
            return new DatarouterSecretWebPlugin(this.buildBasePlugin(), this.secretHandlerPermissions, new DatarouterSecretDaoModule(this.defaultClientId));
        }

        public BaseWebPlugin build() {
            return this.getWebPlugin();
        }

        public static class DatarouterSecretWebPluginBuilderImpl
        extends DatarouterSecretWebPluginBuilder<DatarouterSecretWebPluginBuilderImpl> {
            public DatarouterSecretWebPluginBuilderImpl(ClientId defaultClientId) {
                super(defaultClientId);
            }

            protected DatarouterSecretWebPluginBuilderImpl getSelf() {
                return this;
            }
        }
    }
}

