/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.secretweb.web;

import com.google.gson.JsonSyntaxException;
import io.datarouter.httpclient.endpoint.param.RequestBody;
import io.datarouter.instrumentation.changelog.ChangelogRecorder;
import io.datarouter.scanner.Scanner;
import io.datarouter.secret.config.SecretClientSupplierConfig;
import io.datarouter.secret.op.SecretOpConfig;
import io.datarouter.secret.op.SecretOpReason;
import io.datarouter.secret.op.client.SecretClientOpType;
import io.datarouter.secret.service.SecretJsonSerializer;
import io.datarouter.secret.service.SecretService;
import io.datarouter.secretweb.config.DatarouterSecretFiles;
import io.datarouter.secretweb.config.DatarouterSecretPaths;
import io.datarouter.secretweb.service.WebSecretOpReason;
import io.datarouter.secretweb.web.SecretClientSupplierConfigDto;
import io.datarouter.secretweb.web.SecretHandlerOpRequestDto;
import io.datarouter.secretweb.web.SecretHandlerOpResultDto;
import io.datarouter.util.string.StringTool;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.html.react.bootstrap4.Bootstrap4ReactPageFactory;
import jakarta.inject.Inject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecretHandler
extends BaseHandler {
    private static final Logger logger = LoggerFactory.getLogger(SecretHandler.class);
    @Inject
    private DatarouterSecretFiles files;
    @Inject
    private DatarouterSecretPaths paths;
    @Inject
    private SecretJsonSerializer jsonSerializer;
    @Inject
    private SecretService secretService;
    @Inject
    private Bootstrap4ReactPageFactory reactPageFactory;
    @Inject
    private ChangelogRecorder changelogRecorder;

    @BaseHandler.Handler(defaultHandler=true)
    private Mav index() {
        return this.reactPageFactory.startBuilder(this.request).withTitle("Datarouter - Secrets").withReactScript(this.files.js.secretsJsx).withJsStringConstant("PATH_HANDLE", this.request.getContextPath() + this.paths.datarouter.secrets.handle.toSlashedString()).withJsStringConstant("PATH_CONFIG", this.request.getContextPath() + this.paths.datarouter.secrets.getSecretClientSupplierConfig.toSlashedString()).buildMav();
    }

    @BaseHandler.Handler
    public SecretClientSupplierConfigDto.SecretClientSupplierConfigsDto getSecretClientSupplierConfig() {
        List secretClientSupplierConfigs = this.secretService.getSecretClientSupplierConfigs();
        List orderedConfigs = Scanner.of((Iterable)secretClientSupplierConfigs).map(SecretClientSupplierConfig::getConfigName).list();
        return new SecretClientSupplierConfigDto.SecretClientSupplierConfigsDto(orderedConfigs, Scanner.of((Iterable)secretClientSupplierConfigs).map(config -> new SecretClientSupplierConfigDto(config.getConfigName(), config.getSecretClientSupplierClass().getSimpleName(), this.buildAllowedOps(config.getAllowedOps()), config.getAllowedNames().map(Scanner::of).map(Scanner::toMap).orElseGet(Map::of))).toMap(dto -> dto.configName));
    }

    @BaseHandler.Handler
    public SecretHandlerOpResultDto handle(@RequestBody SecretHandlerOpRequestDto requestDto) {
        SecretHandlerOpResultDto result = this.validateRequest(requestDto);
        if (result == null) {
            result = this.executeAuthorizedRequest(requestDto);
            if (requestDto.op != SecretHandlerOpRequestDto.SecretOpDto.LIST_ALL) {
                ChangelogRecorder.DatarouterChangelogDto dto = new ChangelogRecorder.DatarouterChangelogDtoBuilder("Secrets", requestDto.name, requestDto.op.getPersistentString(), this.getSessionInfo().getNonEmptyUsernameOrElse("")).build();
                this.changelogRecorder.record(dto);
            }
        }
        return result;
    }

    private Map<SecretHandlerOpRequestDto.SecretOpDto, SecretHandlerOpRequestDto.SecretOpDto> buildAllowedOps(Set<SecretClientOpType> serviceOps) {
        HashSet<SecretHandlerOpRequestDto.SecretOpDto> allowedOps = new HashSet<SecretHandlerOpRequestDto.SecretOpDto>();
        if (serviceOps.contains(SecretClientOpType.CREATE) || serviceOps.contains(SecretClientOpType.PUT)) {
            allowedOps.add(SecretHandlerOpRequestDto.SecretOpDto.CREATE);
        }
        if (serviceOps.contains(SecretClientOpType.READ)) {
            allowedOps.add(SecretHandlerOpRequestDto.SecretOpDto.READ);
        }
        if (serviceOps.contains(SecretClientOpType.UPDATE) || serviceOps.contains(SecretClientOpType.PUT)) {
            allowedOps.add(SecretHandlerOpRequestDto.SecretOpDto.UPDATE);
        }
        if (serviceOps.contains(SecretClientOpType.DELETE)) {
            allowedOps.add(SecretHandlerOpRequestDto.SecretOpDto.DELETE);
        }
        if (serviceOps.contains(SecretClientOpType.LIST)) {
            allowedOps.add(SecretHandlerOpRequestDto.SecretOpDto.LIST_ALL);
        }
        return Scanner.of(allowedOps).toMap();
    }

    private SecretHandlerOpResultDto validateRequest(SecretHandlerOpRequestDto requestDto) {
        if (requestDto.op == null) {
            return SecretHandlerOpResultDto.error("Op is required.");
        }
        switch (requestDto.op) {
            case CREATE: {
                if (StringTool.isNullOrEmptyOrWhitespace((String)requestDto.secretClass)) {
                    return SecretHandlerOpResultDto.error("SecretClass is required for this op.");
                }
            }
            case UPDATE: {
                if (StringTool.isNullOrEmptyOrWhitespace((String)requestDto.name)) {
                    return SecretHandlerOpResultDto.error("Name is required for this op.");
                }
                if (!StringTool.isNullOrEmptyOrWhitespace((String)requestDto.value)) break;
                return SecretHandlerOpResultDto.error("Value is required for this op.");
            }
            case READ: 
            case DELETE: {
                if (!StringTool.isNullOrEmptyOrWhitespace((String)requestDto.name)) break;
                return SecretHandlerOpResultDto.error("Name is required for this op.");
            }
            case LIST_ALL: {
                break;
            }
            default: {
                return SecretHandlerOpResultDto.error("Unknown op.");
            }
        }
        return null;
    }

    private SecretHandlerOpResultDto executeAuthorizedRequest(SecretHandlerOpRequestDto requestDto) {
        try {
            SecretOpReason opReason = WebSecretOpReason.manualOp(this.getSessionInfo().getRequiredSession(), "SecretHandler");
            Optional configName = StringTool.isEmptyOrWhitespace((String)requestDto.configName) ? Optional.empty() : Optional.ofNullable(requestDto.configName);
            switch (requestDto.op) {
                case CREATE: {
                    try {
                        String secretValue = requestDto.value;
                        this.jsonSerializer.serialize(this.jsonSerializer.deserialize(secretValue, Class.forName(requestDto.secretClass)));
                        SecretOpConfig config = SecretOpConfig.builder((SecretOpReason)opReason).useTargetSecretClientConfig(configName).disableSerialization().build();
                        this.secretService.create(requestDto.name, (Object)secretValue, config);
                    }
                    catch (ClassNotFoundException e) {
                        return SecretHandlerOpResultDto.error("Provided class cannot be found.");
                    }
                    return SecretHandlerOpResultDto.success();
                }
                case UPDATE: {
                    SecretOpConfig config = SecretOpConfig.builder((SecretOpReason)opReason).useTargetSecretClientConfig(configName).disableSerialization().build();
                    this.secretService.update(requestDto.name, (Object)requestDto.value, config);
                    return SecretHandlerOpResultDto.success();
                }
                case READ: {
                    SecretOpConfig config = SecretOpConfig.builder((SecretOpReason)opReason).useTargetSecretClientConfig(configName).disableSerialization().build();
                    return SecretHandlerOpResultDto.read((String)this.secretService.read(requestDto.name, String.class, config));
                }
                case DELETE: {
                    SecretOpConfig config = SecretOpConfig.builder((SecretOpReason)opReason).useTargetSecretClientConfig(configName).build();
                    this.secretService.delete(requestDto.name, config);
                    return SecretHandlerOpResultDto.success();
                }
                case LIST_ALL: {
                    SecretOpConfig config = SecretOpConfig.builder((SecretOpReason)opReason).useTargetSecretClientConfig(configName).build();
                    List appNames = Scanner.of((Iterable)this.secretService.listSecretNames(Optional.empty(), config)).sort(String.CASE_INSENSITIVE_ORDER).list();
                    config = SecretOpConfig.builder((SecretOpReason)opReason).useSharedNamespace().useTargetSecretClientConfig(configName).build();
                    List sharedNames = Scanner.of((Iterable)this.secretService.listSecretNames(Optional.empty(), config)).sort(String.CASE_INSENSITIVE_ORDER).list();
                    return SecretHandlerOpResultDto.list(appNames, sharedNames);
                }
            }
            return SecretHandlerOpResultDto.error("Unknown op.");
        }
        catch (JsonSyntaxException e) {
            String errorMessage = String.format("Failed SecretHandler operation due to JsonSyntaxException for secretName=%s, operation=%s, decodedClassType=%s", requestDto.name, requestDto.op.getPersistentString(), requestDto.secretClass);
            logger.warn(errorMessage);
            return SecretHandlerOpResultDto.error(errorMessage);
        }
        catch (RuntimeException e) {
            logger.warn("Failed SecretHandler operation: ", (Throwable)e);
            return SecretHandlerOpResultDto.error(e.getMessage());
        }
    }
}

