/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.secretweb.service;

import io.datarouter.secret.service.SecretNamespacer;
import io.datarouter.storage.config.environment.EnvironmentType;
import io.datarouter.storage.config.properties.DatarouterEnvironmentTypeSupplier;
import io.datarouter.storage.config.properties.ServiceName;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Objects;

@Singleton
public class DatarouterPropertiesAndServiceSecretNamespacer
implements SecretNamespacer {
    @Inject
    private DatarouterEnvironmentTypeSupplier environmentType;
    @Inject
    private ServiceName serviceName;

    private String getEnvironment() {
        return Objects.requireNonNull(this.environmentType.get());
    }

    public String getAppNamespace() {
        return this.getEnvironment() + "/" + Objects.requireNonNull(this.serviceName.get()) + "/";
    }

    public String getSharedNamespace() {
        return this.getEnvironment() + "/shared/";
    }

    public boolean isDevelopment() {
        return EnvironmentType.DEVELOPMENT.get().getPersistentString().equals(this.getEnvironment());
    }
}

