/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.scanner;

import io.datarouter.scanner.Scanner;
import java.util.Iterator;

public class ScannerIterator<T>
implements Iterator<T> {
    private final Scanner<T> scanner;
    private boolean isPeeked;
    private T peekedItem;

    public ScannerIterator(Scanner<T> scanner) {
        this.scanner = scanner;
        this.isPeeked = false;
        this.peekedItem = null;
    }

    @Override
    public boolean hasNext() {
        if (this.isPeeked) {
            return true;
        }
        if (this.scanner.advance()) {
            this.peekedItem = this.scanner.current();
            this.isPeeked = true;
            return true;
        }
        this.peekedItem = null;
        this.isPeeked = false;
        this.scanner.close();
        return false;
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            T item = this.peekedItem;
            this.peekedItem = null;
            this.isPeeked = false;
            return item;
        }
        return null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

