/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.redis;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.field.FieldTool;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.file.PathbeanKey;
import io.datarouter.storage.serialize.fieldcache.PhysicalDatabeanFieldInfo;
import io.datarouter.util.bytes.ByteTool;
import io.datarouter.util.bytes.IntegerByteTool;
import java.util.List;

public class RedisBlobCodec<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> {
    private static final int CODEC_VERSION = 1;
    private final PhysicalDatabeanFieldInfo<PK, D, F> fieldInfo;
    private final int schemaVersion;

    public RedisBlobCodec(PhysicalDatabeanFieldInfo<PK, D, F> fieldInfo, int nodeVersion) {
        this.fieldInfo = fieldInfo;
        this.schemaVersion = nodeVersion;
    }

    public byte[] encodeKey(PathbeanKey pk) {
        byte[] codecVersion = IntegerByteTool.getRawBytes((int)1);
        byte[] key = FieldTool.getConcatenatedValueBytes((List)pk.getFields());
        byte[] version = IntegerByteTool.getRawBytes((int)this.schemaVersion);
        return ByteTool.concatenate((byte[][])new byte[][]{codecVersion, version, key});
    }
}

