/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.redis;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.databean.DatabeanTool;
import io.datarouter.model.field.Field;
import io.datarouter.model.field.FieldSetTool;
import io.datarouter.model.field.FieldTool;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.tally.Tally;
import io.datarouter.storage.tally.TallyKey;
import io.datarouter.util.bytes.ByteTool;
import io.datarouter.util.bytes.IntegerByteTool;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class RedisTallyCodec {
    private static final Tally.TallyFielder SAMPLE_FIELDER = new Tally.TallyFielder();
    private final int version;

    public RedisTallyCodec(int version) {
        this.version = version;
    }

    public byte[] encodeKey(TallyKey pk) {
        byte[] key = FieldTool.getConcatenatedValueBytes((List)pk.getFields());
        byte[] schemaVersion = IntegerByteTool.getRawBytes((int)this.version);
        return ByteTool.concatenate((byte[][])new byte[][]{schemaVersion, key});
    }

    public byte[] encode(Tally databean) {
        return DatabeanTool.getBytes((Databean)databean, (DatabeanFielder)SAMPLE_FIELDER);
    }

    public <D> D decode(Supplier<D> supplier, Map<String, Field<?>> fieldByPrefixedName, byte[] bytes) {
        return (D)FieldSetTool.fieldSetFromBytes(supplier, fieldByPrefixedName, (byte[])bytes);
    }
}

