/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.redis.node;

import io.datarouter.client.redis.RedisClientType;
import io.datarouter.client.redis.client.RedisClientManager;
import io.datarouter.client.redis.node.RedisReaderNode;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.databean.DatabeanTool;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.scanner.ParallelScannerContext;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.op.raw.TallyStorage;
import io.datarouter.storage.tally.TallyKey;
import io.lettuce.core.RedisFuture;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisNode<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>>
extends RedisReaderNode<PK, D, F>
implements TallyStorage.PhysicalTallyStorageNode<PK, D, F> {
    private static final Logger logger = LoggerFactory.getLogger(RedisNode.class);
    private static final int MAX_REDIS_KEY_SIZE = 65536;

    public RedisNode(NodeParams<PK, D, F> params, RedisClientType redisClientType, RedisClientManager redisClientManager, ClientId clientId, ExecutorService executor) {
        super(params, redisClientType, redisClientManager, clientId, executor);
    }

    public void put(D databean, Config config) {
        if (databean == null) {
            return;
        }
        byte[] key = this.codec.encode(databean.getKey());
        if (key.length > 65536) {
            logger.error("redis object too big for redis! " + databean.getDatabeanName() + ", key: " + key);
            return;
        }
        Long ttl = null;
        if (config != null && config.getTtl() != null) {
            ttl = this.getTtlMs(config);
        }
        byte[] databeanBytes = DatabeanTool.getBytes(databean, (DatabeanFielder)this.getFieldInfo().getSampleFielder());
        if (ttl == null) {
            try {
                this.client().set((Object)key, (Object)databeanBytes).get();
            }
            catch (InterruptedException | ExecutionException e) {
                logger.error("", (Throwable)e);
            }
        } else {
            try {
                this.client().psetex((Object)key, ttl.longValue(), (Object)databeanBytes).get();
            }
            catch (InterruptedException | ExecutionException e) {
                logger.error("", (Throwable)e);
            }
        }
    }

    public void putMulti(Collection<D> databeans, Config config) {
        if (databeans == null || databeans.isEmpty()) {
            return;
        }
        HashMap<byte[], byte[]> keysAndDatabeans = new HashMap<byte[], byte[]>();
        for (Databean databean : databeans) {
            byte[] key = this.codec.encode(databean.getKey());
            if (key.length > 65536) {
                logger.error("redis object too big for redis! " + databean.getDatabeanName() + ", key: " + key);
                continue;
            }
            byte[] databeanBytes = DatabeanTool.getBytes((Databean)databean, (DatabeanFielder)this.getFieldInfo().getSampleFielder());
            keysAndDatabeans.put(key, databeanBytes);
        }
        Long ttl = null;
        if (config != null && config.getTtl() != null) {
            ttl = this.getTtlMs(config);
        }
        if (ttl == null) {
            try {
                this.client().mset(keysAndDatabeans).get();
            }
            catch (InterruptedException | ExecutionException e) {
                logger.error("", (Throwable)e);
            }
        } else {
            long ttlMs = ttl;
            Scanner.of(keysAndDatabeans.entrySet()).parallel(new ParallelScannerContext(this.executor, 16, true)).forEach(entry -> {
                try {
                    this.client().psetex((Object)((byte[])entry.getKey()), ttlMs, (Object)((byte[])entry.getValue())).get();
                }
                catch (InterruptedException | ExecutionException e) {
                    logger.error("", (Throwable)e);
                }
            });
        }
    }

    public void deleteAll(Config config) {
        throw new UnsupportedOperationException();
    }

    public void delete(PK key, Config config) {
        if (key == null) {
            return;
        }
        try {
            this.client().del((Object[])new byte[][]{this.codec.encode(key)}).get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("", (Throwable)e);
        }
    }

    public void deleteMulti(Collection<PK> keys, Config config) {
        if (keys == null || keys.isEmpty()) {
            return;
        }
        try {
            this.client().del((Object[])this.encodeKeys(keys)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("", (Throwable)e);
        }
    }

    public Long incrementAndGetCount(String key, int delta, Config config) {
        if (key == null) {
            return null;
        }
        byte[] tallyKey = this.codec.encode((PrimaryKey)new TallyKey(key));
        RedisFuture increment = this.client().incrby((Object)tallyKey, (long)delta);
        Long expiration = this.getTtlMs(config);
        RedisFuture expire = null;
        if (expiration != null) {
            expire = this.client().pexpire((Object)tallyKey, expiration.longValue());
        }
        try {
            long count = (Long)increment.get();
            expire.get();
            return count;
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }

    public void deleteTally(String key, Config config) {
        if (key == null) {
            return;
        }
        try {
            this.client().del((Object[])new byte[][]{this.codec.encode((PrimaryKey)new TallyKey(key))}).get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("", (Throwable)e);
        }
    }

    private Long getTtlMs(Config config) {
        if (config == null) {
            return null;
        }
        return Optional.ofNullable(config.getTtl()).map(Duration::toMillis).orElse(Long.MAX_VALUE);
    }
}

