/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.redis.node;

import io.datarouter.client.redis.RedisClientType;
import io.datarouter.client.redis.client.RedisClientManager;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.JsonDatabeanTool;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientType;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.op.raw.read.MapStorageReader;
import io.datarouter.storage.node.op.raw.read.TallyStorageReader;
import io.datarouter.storage.node.type.physical.base.BasePhysicalNode;
import io.datarouter.storage.tally.TallyKey;
import io.datarouter.storage.util.EncodedPrimaryKeyPercentCodec;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import redis.clients.jedis.Jedis;

public class RedisReaderNode<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>>
extends BasePhysicalNode<PK, D, F>
implements MapStorageReader<PK, D>,
TallyStorageReader<PK, D> {
    private final Integer databeanVersion;
    protected final RedisClientManager redisClientManager;
    protected final ClientId clientId;

    public RedisReaderNode(NodeParams<PK, D, F> params, RedisClientType redisClientType, RedisClientManager redisClientManager, ClientId clientId) {
        super(params, (ClientType)redisClientType);
        this.redisClientManager = redisClientManager;
        this.clientId = clientId;
        this.databeanVersion = Optional.ofNullable(params.getSchemaVersion()).orElse(1);
    }

    public boolean exists(PK key, Config config) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Jedis client = this.redisClientManager.getJedis(this.clientId).getResource();){
            return client.exists(this.buildRedisKey((PrimaryKey<?>)key));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public D get(PK key, Config config) {
        String json;
        if (key == null) {
            return null;
        }
        Throwable throwable = null;
        Object var5_5 = null;
        try (Jedis client = this.redisClientManager.getJedis(this.clientId).getResource();){
            json = client.get(this.buildRedisKey((PrimaryKey<?>)key));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (json == null) {
            return null;
        }
        return (D)JsonDatabeanTool.databeanFromJson((Supplier)this.getFieldInfo().getDatabeanSupplier(), (DatabeanFielder)this.getFieldInfo().getSampleFielder(), (String)json);
    }

    public List<D> getMulti(Collection<PK> keys, Config config) {
        if (keys == null || keys.isEmpty()) {
            return List.of();
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (Jedis client = this.redisClientManager.getJedis(this.clientId).getResource();){
            return client.mget(this.buildRedisKeys(keys).toArray(new String[keys.size()])).stream().filter(Objects::nonNull).map(bean -> JsonDatabeanTool.databeanFromJson((Supplier)this.getFieldInfo().getDatabeanSupplier(), (DatabeanFielder)this.getFieldInfo().getSampleFielder(), (String)bean)).collect(Collectors.toList());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public List<PK> getKeys(Collection<PK> keys, Config config) {
        if (keys == null || keys.isEmpty()) {
            return List.of();
        }
        return Scanner.of(this.getMulti(keys, config)).map(Databean::getKey).list();
    }

    public Optional<Long> findTallyCount(String key, Config config) {
        if (key == null) {
            return null;
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (Jedis client = this.redisClientManager.getJedis(this.clientId).getResource();){
            return Optional.ofNullable(client.get(this.buildRedisKey((PrimaryKey<?>)new TallyKey(key)))).map(String::trim).map(Long::valueOf);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Map<String, Long> getMultiTallyCount(Collection<String> keys, Config config) {
        return keys.stream().collect(Collectors.toMap(Function.identity(), key -> this.findTallyCount((String)key).orElse(0L)));
    }

    protected String buildRedisKey(PrimaryKey<?> pk) {
        return new EncodedPrimaryKeyPercentCodec(this.getName(), this.databeanVersion, pk).getVersionedKeyString();
    }

    protected List<String> buildRedisKeys(Collection<? extends PrimaryKey<?>> pks) {
        return EncodedPrimaryKeyPercentCodec.getVersionedKeyStrings((String)this.getName(), (int)this.databeanVersion, pks);
    }
}

