/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.redis.client;

import io.datarouter.client.redis.client.RedisOptions;
import io.datarouter.storage.client.ClientId;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

@Singleton
public class JedisHolder {
    private static final int CONNECTION_TIMEOUT = (int)Duration.ofSeconds(3L).toMillis();
    @Inject
    private RedisOptions redisOptions;
    private final Map<ClientId, JedisPool> jedisByClient = new ConcurrentHashMap<ClientId, JedisPool>();

    public void registerClient(ClientId clientId) {
        if (this.jedisByClient.containsKey(clientId)) {
            throw new RuntimeException(clientId + " already registered a JedisClient");
        }
        this.jedisByClient.put(clientId, this.buildClient(clientId));
    }

    public JedisPool get(ClientId clientId) {
        return this.jedisByClient.get(clientId);
    }

    private JedisPool buildClient(ClientId clientId) {
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxTotal(128);
        poolConfig.setMaxIdle(128);
        poolConfig.setMinIdle(16);
        InetSocketAddress addresses = this.redisOptions.getEndpoint(clientId.getName());
        String host = addresses.getHostName();
        int port = addresses.getPort();
        return new JedisPool((GenericObjectPoolConfig)poolConfig, host, port, CONNECTION_TIMEOUT);
    }
}

