/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.redis.web;

import io.datarouter.client.redis.RedisClientType;
import io.datarouter.client.redis.client.RedisClientManager;
import io.datarouter.client.redis.client.RedisOptions;
import io.datarouter.storage.client.ClientId;
import io.datarouter.web.browse.DatarouterClientWebInspector;
import io.datarouter.web.browse.dto.DatarouterWebRequestParamsFactory;
import io.datarouter.web.config.ServletContextSupplier;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.handler.params.Params;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4PageFactory;
import io.datarouter.web.requirejs.DatarouterWebRequireJsV2;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import redis.clients.jedis.Jedis;

public class RedisWebInspector
implements DatarouterClientWebInspector {
    @Inject
    private RedisOptions redisOptions;
    @Inject
    private RedisClientManager redisClientManager;
    @Inject
    private DatarouterWebRequestParamsFactory datarouterWebRequestParamsFactory;
    @Inject
    private ServletContextSupplier servletContext;
    @Inject
    private Bootstrap4PageFactory pageFactory;

    public Mav inspectClient(Params params, HttpServletRequest request) {
        DatarouterWebRequestParamsFactory datarouterWebRequestParamsFactory = this.datarouterWebRequestParamsFactory;
        datarouterWebRequestParamsFactory.getClass();
        DatarouterWebRequestParamsFactory.DatarouterWebRequestParams clientParams = new DatarouterWebRequestParamsFactory.DatarouterWebRequestParams(datarouterWebRequestParamsFactory, params, RedisClientType.class);
        ClientId clientId = clientParams.getClientId();
        ContainerTag content = (ContainerTag)TagCreator.div((DomContent[])new DomContent[]{TagCreator.h2((String)("Datarouter " + clientId.getName())), DatarouterClientWebInspector.buildNav((String)((ServletContext)this.servletContext.get()).getContextPath(), (String)clientId.getName()), TagCreator.h3((String)"Client Summary"), this.buildOverview(clientId)}).withClass("container my-3");
        return this.pageFactory.startBuilder(request).withTitle("Datarouter Client - Redis").withRequires(new String[]{DatarouterWebRequireJsV2.SORTTABLE}).withContent(content).buildMav();
    }

    private ContainerTag buildOverview(ClientId clientId) {
        Jedis client = this.redisClientManager.getJedis(clientId);
        String mode = this.redisOptions.getClientMode(clientId.getName());
        String clusterEndpoint = "";
        if (mode.equals("dynamic")) {
            clusterEndpoint = this.redisOptions.getClusterEndpoint(clientId.getName()).get().toString();
        }
        return TagCreator.dl((DomContent[])new DomContent[]{TagCreator.dt((String)"Client mode:"), TagCreator.dd((String)mode), TagCreator.dt((String)"Cluster endpoint:"), TagCreator.dd((String)clusterEndpoint), TagCreator.dt((String)"Cluster info"), TagCreator.dd((String)client.clusterInfo())});
    }
}

