/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.redis.node;

import io.datarouter.client.redis.RedisClientType;
import io.datarouter.client.redis.client.RedisClientManager;
import io.datarouter.client.redis.databean.RedisDatabeanKey;
import io.datarouter.client.redis.node.RedisNodeKey;
import io.datarouter.instrumentation.trace.Tracer;
import io.datarouter.instrumentation.trace.TracerThreadLocal;
import io.datarouter.instrumentation.trace.TracerTool;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.databean.DatabeanTool;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.JsonDatabeanTool;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientType;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.op.raw.read.MapStorageReader;
import io.datarouter.storage.node.type.physical.base.BasePhysicalNode;
import io.datarouter.util.collection.CollectionTool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class RedisReaderNode<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>>
extends BasePhysicalNode<PK, D, F>
implements MapStorageReader<PK, D> {
    private final Integer databeanVersion;
    private final RedisClientManager redisClientManager;
    private final ClientId clientId;

    public RedisReaderNode(NodeParams<PK, D, F> params, RedisClientType redisClientType, RedisClientManager redisClientManager, ClientId clientId) {
        super(params, (ClientType)redisClientType);
        this.redisClientManager = redisClientManager;
        this.clientId = clientId;
        this.databeanVersion = Objects.requireNonNull(params.getSchemaVersion());
    }

    public boolean exists(PK key, Config config) {
        try {
            this.startTraceSpan("redis exists");
            boolean bl = this.redisClientManager.getJedis(this.clientId).exists(this.buildRedisKey((PrimaryKey<?>)key));
            return bl;
        }
        finally {
            this.finishTraceSpan();
        }
    }

    public D get(PK key, Config config) {
        if (key == null) {
            return null;
        }
        try {
            this.startTraceSpan("redis get");
            String json = this.redisClientManager.getJedis(this.clientId).get(this.buildRedisKey((PrimaryKey<?>)key));
            if (json == null) {
                return null;
            }
            Databean databean = JsonDatabeanTool.databeanFromJson((Supplier)this.getFieldInfo().getDatabeanSupplier(), (DatabeanFielder)this.getFieldInfo().getSampleFielder(), (String)json);
            return (D)databean;
        }
        finally {
            this.finishTraceSpan();
        }
    }

    public List<D> getMulti(Collection<PK> keys, Config config) {
        if (CollectionTool.isEmpty(keys)) {
            return Collections.emptyList();
        }
        List jsons = new ArrayList();
        try {
            this.startTraceSpan("redis get multi");
            jsons = this.redisClientManager.getJedis(this.clientId).mget(this.buildRedisKeys(keys).toArray(new String[keys.size()]));
        }
        finally {
            this.finishTraceSpan();
        }
        return jsons.stream().filter(Objects::nonNull).map(bean -> JsonDatabeanTool.databeanFromJson((Supplier)this.getFieldInfo().getDatabeanSupplier(), (DatabeanFielder)this.getFieldInfo().getSampleFielder(), (String)bean)).collect(Collectors.toList());
    }

    public List<PK> getKeys(Collection<PK> keys, Config config) {
        if (CollectionTool.isEmpty(keys)) {
            return Collections.emptyList();
        }
        return DatabeanTool.getKeys(this.getMulti(keys, config));
    }

    public Long getTallyCount(RedisDatabeanKey key) {
        if (key == null) {
            return null;
        }
        try {
            this.startTraceSpan("redis getTallyCount");
            String tallyCount = this.redisClientManager.getJedis(this.clientId).get(this.buildRedisKey((PrimaryKey<?>)key));
            if (tallyCount == null) {
                return null;
            }
            Long l = Long.valueOf(tallyCount.trim());
            return l;
        }
        finally {
            this.finishTraceSpan();
        }
    }

    protected String buildRedisKey(PrimaryKey<?> pk) {
        return new RedisNodeKey(this.getName(), this.databeanVersion, pk).getVersionedKeyString();
    }

    protected List<String> buildRedisKeys(Collection<? extends PrimaryKey<?>> pks) {
        return RedisNodeKey.getVersionedKeyStrings(this.getName(), this.databeanVersion, pks);
    }

    protected void startTraceSpan(String opName) {
        TracerTool.startSpan((Tracer)TracerThreadLocal.get(), (String)(String.valueOf(this.getName()) + " " + opName));
    }

    protected void finishTraceSpan() {
        TracerTool.finishSpan((Tracer)TracerThreadLocal.get());
    }
}

