/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.redis.node;

import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.storage.util.PrimaryKeyPercentCodec;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class RedisNodeKey {
    private static final Integer VERSION = 1;
    private final String nodeName;
    private final Integer databeanVersion;
    private final PrimaryKey<?> primaryKey;

    public RedisNodeKey(String nodeName, Integer databeanVersion, PrimaryKey<?> primaryKey) {
        if (nodeName.contains(":")) {
            throw new IllegalArgumentException("nodeName cannot contain \":\"");
        }
        this.nodeName = nodeName;
        this.databeanVersion = databeanVersion;
        this.primaryKey = primaryKey;
    }

    public String getVersionedKeyString() {
        String encodedPk = PrimaryKeyPercentCodec.encode(this.primaryKey);
        return VERSION + ":" + this.nodeName + ":" + this.databeanVersion + ":" + encodedPk;
    }

    public static List<String> getVersionedKeyStrings(String nodeName, int version, Collection<? extends PrimaryKey<?>> keys) {
        return keys.stream().filter(Objects::nonNull).map(pk -> new RedisNodeKey(nodeName, version, (PrimaryKey<?>)pk)).map(RedisNodeKey::getVersionedKeyString).collect(Collectors.toList());
    }
}

