/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.redis.node;

import io.datarouter.client.redis.RedisClientType;
import io.datarouter.client.redis.client.RedisClientManager;
import io.datarouter.client.redis.databean.RedisDatabeanKey;
import io.datarouter.client.redis.node.RedisReaderNode;
import io.datarouter.instrumentation.trace.TracerTool;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.JsonDatabeanTool;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.op.raw.MapStorage;
import io.datarouter.util.collection.CollectionTool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.params.SetParams;

public class RedisNode<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>>
extends RedisReaderNode<PK, D, F>
implements MapStorage.PhysicalMapStorageNode<PK, D, F> {
    private static final Logger logger = LoggerFactory.getLogger(RedisNode.class);
    private static final int MAX_REDIS_KEY_SIZE = 65536;
    private final RedisClientManager redisClientManager;
    private final ClientId clientId;

    public RedisNode(NodeParams<PK, D, F> params, RedisClientType redisClientType, RedisClientManager redisClientManager, ClientId clientId) {
        super(params, redisClientType, redisClientManager, clientId);
        this.redisClientManager = redisClientManager;
        this.clientId = clientId;
    }

    public void put(D databean, Config config) {
        if (databean == null) {
            return;
        }
        String key = this.buildRedisKey(databean.getKey());
        if (key.length() > 65536) {
            String jsonKey = JsonDatabeanTool.fieldsToJson((List)databean.getKey().getFields()).toString();
            logger.error("redis object too big for redis! " + databean.getDatabeanName() + ", key: " + jsonKey);
            return;
        }
        Long ttl = null;
        if (config != null && config.getTtl() != null) {
            ttl = this.getTtlMs(config);
        }
        String jsonBean = JsonDatabeanTool.databeanToJsonString(databean, (DatabeanFielder)this.getFieldInfo().getSampleFielder());
        try {
            this.startTraceSpan("redis put");
            if (ttl == null) {
                this.redisClientManager.getJedis(this.clientId).set(key, jsonBean);
            } else {
                this.redisClientManager.getJedis(this.clientId).set(key, jsonBean, new SetParams().xx().px(ttl.longValue()));
            }
        }
        finally {
            this.finishTraceSpan();
        }
    }

    public void putMulti(Collection<D> databeans, Config config) {
        if (CollectionTool.isEmpty(databeans)) {
            return;
        }
        if (config != null && config.getTtl() != null) {
            databeans.forEach(databean -> this.put(databean, config));
            return;
        }
        ArrayList<String> keysAndDatabeans = new ArrayList<String>();
        for (Databean databean2 : databeans) {
            String key = this.buildRedisKey(databean2.getKey());
            if (key.length() > 65536) {
                logger.error("redis object too big for redis! " + databean2.getDatabeanName() + ", key: " + key);
                continue;
            }
            String jsonBean = JsonDatabeanTool.databeanToJsonString((Databean)databean2, (DatabeanFielder)this.getFieldInfo().getSampleFielder());
            keysAndDatabeans.add(key);
            keysAndDatabeans.add(jsonBean);
        }
        try {
            this.startTraceSpan("redis put multi");
            TracerTool.appendToSpanInfo((TracerTool.TraceSpanInfoBuilder)new TracerTool.TraceSpanInfoBuilder().databeans((Number)CollectionTool.size(databeans)));
            this.redisClientManager.getJedis(this.clientId).mset(keysAndDatabeans.toArray(new String[keysAndDatabeans.size()]));
        }
        finally {
            this.finishTraceSpan();
        }
    }

    public void deleteAll(Config config) {
        throw new UnsupportedOperationException();
    }

    public void delete(PK key, Config config) {
        if (key == null) {
            return;
        }
        try {
            this.startTraceSpan("redis delete");
            this.redisClientManager.getJedis(this.clientId).del(this.buildRedisKey((PrimaryKey<?>)key));
        }
        finally {
            this.finishTraceSpan();
        }
    }

    public void deleteMulti(Collection<PK> keys, Config config) {
        if (CollectionTool.isEmpty(keys)) {
            return;
        }
        try {
            this.startTraceSpan("redis delete multi");
            this.redisClientManager.getJedis(this.clientId).del(this.buildRedisKeys(keys).toArray(new String[keys.size()]));
        }
        finally {
            this.finishTraceSpan();
        }
    }

    public void increment(RedisDatabeanKey redisKey, int delta) {
        if (redisKey == null) {
            return;
        }
        String key = this.buildRedisKey((PrimaryKey<?>)redisKey);
        try {
            this.startTraceSpan("redis increment");
            this.redisClientManager.getJedis(this.clientId).incrBy(key, (long)delta);
            return;
        }
        finally {
            this.finishTraceSpan();
        }
    }

    public void increment(RedisDatabeanKey redisKey, int delta, Config config) {
        if (redisKey == null) {
            return;
        }
        String key = this.buildRedisKey((PrimaryKey<?>)redisKey);
        Long ttl = this.getTtlMs(config);
        try {
            this.startTraceSpan("redis increment");
            if (ttl == null) {
                this.redisClientManager.getJedis(this.clientId).incrBy(key, (long)delta);
                return;
            }
            this.redisClientManager.getJedis(this.clientId).incrBy(key, (long)delta);
            this.redisClientManager.getJedis(this.clientId).pexpire(key, ttl.longValue());
            return;
        }
        finally {
            this.finishTraceSpan();
        }
    }

    public Long incrementAndGetCount(RedisDatabeanKey redisKey, int delta, Config config) {
        if (redisKey == null) {
            return null;
        }
        String key = this.buildRedisKey((PrimaryKey<?>)redisKey);
        Long expiration = this.getTtlMs(config);
        try {
            this.startTraceSpan("redis increment and get count");
            if (expiration == null) {
                Long l = (long)this.redisClientManager.getJedis(this.clientId).incrBy(key, (long)delta);
                return l;
            }
            Long response = this.redisClientManager.getJedis(this.clientId).incrBy(key, (long)delta);
            this.redisClientManager.getJedis(this.clientId).pexpire(key, expiration.longValue());
            Long l = (long)response;
            return l;
        }
        finally {
            this.finishTraceSpan();
        }
    }

    private Long getTtlMs(Config config) {
        if (config == null) {
            return null;
        }
        return config.getTtl() == null ? Long.MAX_VALUE : config.getTtl().toMillis();
    }
}

