/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.redis.client;

import io.datarouter.client.redis.client.RedisOptions;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientOptions;
import io.datarouter.storage.client.ClientOptionsBuilder;
import java.util.Properties;

public class RedisClientOptionsBuilder
implements ClientOptionsBuilder {
    private final String clientIdName;
    private final Properties properties;

    public RedisClientOptionsBuilder(ClientId clientId) {
        this.clientIdName = clientId.getName();
        this.properties = new Properties();
        this.properties.setProperty(ClientOptions.makeClientTypeKey((String)this.clientIdName), "redis");
    }

    public RedisClientOptionsBuilder withNumServers(int numberOfServers) {
        String optionKeySuffix = RedisOptions.makeRedisKey("numServers");
        String optionKey = this.makeKey(optionKeySuffix);
        this.properties.setProperty(optionKey, String.valueOf(numberOfServers));
        return this;
    }

    public RedisClientOptionsBuilder withServerIndexAndInetSocketAddress(int serverIndex, String inetSocketAddress) {
        String optionKeySuffix = RedisOptions.makeRedisKey("server." + serverIndex);
        String optionKey = this.makeKey(optionKeySuffix);
        this.properties.setProperty(optionKey, inetSocketAddress);
        return this;
    }

    public RedisClientOptionsBuilder withClientMode(String clientMode) {
        String optionKeySuffix = RedisOptions.makeRedisKey("clientMode");
        String optionKey = this.makeKey(optionKeySuffix);
        this.properties.setProperty(optionKey, clientMode.toLowerCase());
        return this;
    }

    public RedisClientOptionsBuilder withClusterEndpoint(String clusterEndpoint) {
        String optionKeySuffix = RedisOptions.makeRedisKey("clusterEndpoint");
        String optionKey = this.makeKey(optionKeySuffix);
        this.properties.setProperty(optionKey, clusterEndpoint);
        return this;
    }

    public Properties build() {
        return this.properties;
    }

    private String makeKey(String suffix) {
        return ClientOptions.makeClientPrefixedKey((String)this.clientIdName, (String)suffix);
    }
}

