/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.redis.client;

import io.datarouter.client.redis.client.RedisOptions;
import io.datarouter.storage.client.ClientId;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import redis.clients.jedis.Jedis;

@Singleton
public class JedisHolder {
    @Inject
    private RedisOptions redisOptions;
    private final Map<ClientId, Jedis> jedisByClient = new ConcurrentHashMap<ClientId, Jedis>();

    public void registerClient(ClientId clientId) {
        if (this.jedisByClient.containsKey(clientId)) {
            throw new RuntimeException(clientId + " already registered a JedisClient");
        }
        Jedis jedis = new Jedis(this.buildClient(clientId).get(0).getHostName(), this.buildClient(clientId).get(0).getPort());
        this.jedisByClient.put(clientId, jedis);
    }

    public Jedis get(ClientId clientId) {
        return this.jedisByClient.get(clientId);
    }

    public List<InetSocketAddress> buildClient(ClientId clientId) {
        String clientMode = this.redisOptions.getClientMode(clientId.getName());
        List<InetSocketAddress> addresses = clientMode.equals("dynamic") ? Arrays.asList(this.redisOptions.getClusterEndpoint(clientId.getName()).get()) : this.redisOptions.getServers(clientId.getName());
        return addresses;
    }
}

