/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.redis.client;

import io.datarouter.storage.client.ClientOptions;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class RedisOptions {
    private static final String PREFIX_REDIS = "redis.";
    public static final String PROP_clientMode = "clientMode";
    public static final String PROP_clusterEndpoint = "clusterEndpoint";
    public static final String PROP_numServers = "numServers";
    public static final String PROP_server = "server";
    public static final String DYNAMIC_CLIENT_MODE = "dynamic";
    public static final String STATIC_CLIENT_MODE = "static";
    @Inject
    private ClientOptions clientOptions;

    public List<InetSocketAddress> getServers(String clientName) {
        return IntStream.range(0, this.getNumServers(clientName)).mapToObj(index -> RedisOptions.makeRedisKey("server." + index)).map(propertyKey -> this.clientOptions.optInetSocketAddress(clientName, propertyKey)).map(Optional::get).collect(Collectors.toList());
    }

    public Optional<InetSocketAddress> getClusterEndpoint(String clientName) {
        return this.clientOptions.optInetSocketAddress(clientName, RedisOptions.makeRedisKey(PROP_clusterEndpoint));
    }

    public String getClientMode(String clientName) {
        String clientMode = (String)this.clientOptions.optString(clientName, RedisOptions.makeRedisKey(PROP_clientMode)).get();
        if (!clientMode.equals(DYNAMIC_CLIENT_MODE)) {
            clientMode = STATIC_CLIENT_MODE;
        }
        return clientMode;
    }

    protected static String makeRedisKey(String propertyKey) {
        return PREFIX_REDIS + propertyKey;
    }

    private Integer getNumServers(String clientName) {
        return this.clientOptions.getRequiredInteger(clientName, RedisOptions.makeRedisKey(PROP_numServers));
    }
}

