/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.redis.client;

import io.datarouter.client.redis.client.JedisHolder;
import io.datarouter.storage.client.BaseClientManager;
import io.datarouter.storage.client.ClientId;
import io.datarouter.util.timer.PhaseTimer;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;

@Singleton
public class RedisClientManager
extends BaseClientManager {
    private static final Logger logger = LoggerFactory.getLogger(RedisClientManager.class);
    @Inject
    private JedisHolder jedisHolder;

    public void shutdown(ClientId clientId) {
        this.jedisHolder.get(clientId).close();
    }

    protected void safeInitClient(ClientId clientId) {
        logger.info("activating Redis client " + clientId.getName());
        PhaseTimer timer = new PhaseTimer(clientId.getName());
        this.jedisHolder.registerClient(clientId);
        logger.warn(timer.add("done").toString());
    }

    public Jedis getJedis(ClientId clientId) {
        this.initClient(clientId);
        return this.jedisHolder.get(clientId);
    }
}

