/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.redis.client;

import io.datarouter.enums.StringMappedEnum;
import io.datarouter.storage.client.ClientOptions;
import io.datarouter.storage.config.client.RedisGenericClientOptions;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;

@Singleton
public class RedisOptions {
    private static final String PREFIX_REDIS = "redis.";
    public static final String PROP_endpoint = "endpoint";
    public static final String PROP_clientMode = "clientMode";
    public static final String PROP_numNodes = "numNodes";
    public static final String PROP_node = "node";
    @Inject
    private ClientOptions clientOptions;

    public Optional<InetSocketAddress> getEndpoint(String clientName) {
        return this.clientOptions.optInetSocketAddress(clientName, RedisOptions.makeRedisKey(PROP_endpoint));
    }

    public RedisClientMode getClientMode(String clientName) {
        return this.clientOptions.optString(clientName, RedisOptions.makeRedisKey(PROP_clientMode)).map(arg_0 -> RedisClientMode.BY_PERSISTENT_STRING.fromOrThrow(arg_0)).orElseThrow(() -> new IllegalArgumentException("clientMode needs to be specified"));
    }

    public List<InetSocketAddress> getNodes(String clientName) {
        return IntStream.range(0, this.getNumNodes(clientName)).mapToObj(index -> "node." + index).map(RedisOptions::makeRedisKey).map(propertyKey -> this.clientOptions.optInetSocketAddress(clientName, propertyKey)).map(Optional::get).toList();
    }

    private Integer getNumNodes(String clientName) {
        return this.clientOptions.getRequiredInteger(clientName, RedisOptions.makeRedisKey(PROP_numNodes));
    }

    public static String makeRedisKey(String propertyKey) {
        return PREFIX_REDIS + propertyKey;
    }

    public static enum RedisClientMode {
        AUTO_DISCOVERY("autoDiscovery", true),
        MULTI_NODE("multiNode", true),
        STANDARD("standard", false);

        public static final StringMappedEnum<RedisClientMode> BY_PERSISTENT_STRING;
        public final String persistentString;
        public final boolean isClustered;
        public final boolean isStandard;

        static {
            BY_PERSISTENT_STRING = new StringMappedEnum((Object[])RedisClientMode.values(), value -> value.persistentString);
        }

        private RedisClientMode(String persistentString, boolean isClustered) {
            this.persistentString = persistentString;
            this.isClustered = isClustered;
            this.isStandard = !isClustered;
        }

        public static RedisClientMode fromGenericClientMode(RedisGenericClientOptions.RedisGenericClientMode genericMode) {
            return switch (genericMode) {
                case RedisGenericClientOptions.RedisGenericClientMode.AUTO_DISCOVERY -> AUTO_DISCOVERY;
                case RedisGenericClientOptions.RedisGenericClientMode.MULTI_NODE -> MULTI_NODE;
                case RedisGenericClientOptions.RedisGenericClientMode.STANDARD -> STANDARD;
                default -> throw new MatchException(null, null);
            };
        }
    }
}

