/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.redis.client;

import io.datarouter.client.redis.RedisClientType;
import io.datarouter.client.redis.client.DatarouterRedisClient;
import io.datarouter.client.redis.client.RedisClientHolder;
import io.datarouter.client.redis.client.RedisOptions;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.BaseClientManager;
import io.datarouter.storage.client.ClientId;
import io.datarouter.util.singletonsupplier.SingletonSupplier;
import io.datarouter.util.timer.PhaseTimer;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.async.RedisAsyncCommands;
import io.lettuce.core.cluster.ClusterClientOptions;
import io.lettuce.core.cluster.ClusterTopologyRefreshOptions;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.cluster.api.async.RedisAdvancedClusterAsyncCommands;
import io.lettuce.core.cluster.api.async.RedisClusterAsyncCommands;
import io.lettuce.core.codec.ByteArrayCodec;
import io.lettuce.core.codec.RedisCodec;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RedisClientManager
extends BaseClientManager {
    private static final Logger logger = LoggerFactory.getLogger(RedisClientManager.class);
    @Inject
    private RedisClientType clientType;
    @Inject
    private RedisOptions options;
    @Inject
    private RedisClientHolder holder;

    protected void safeInitClient(ClientId clientId) {
        this.holder.registerClient(clientId, this.buildClient(clientId));
    }

    public void shutdown(ClientId clientId) {
    }

    public DatarouterRedisClient getClient(ClientId clientId) {
        this.initClient(clientId);
        return this.holder.get(clientId);
    }

    private DatarouterRedisClient buildClient(ClientId clientId) {
        if (this.options.getClientMode((String)clientId.getName()).isStandard) {
            return this.buildRegularClient(clientId);
        }
        return this.buildClusterClient(clientId);
    }

    private DatarouterRedisClient buildRegularClient(ClientId clientId) {
        PhaseTimer timer = new PhaseTimer(clientId.getName());
        InetSocketAddress address = this.options.getEndpoint(clientId.getName()).get();
        RedisClient client = RedisClient.create((RedisURI)RedisURI.create((String)address.getHostName(), (int)address.getPort()));
        RedisAsyncCommands lettuceClient = client.connect((RedisCodec)ByteArrayCodec.INSTANCE).async();
        logger.warn(timer.add("buildRegularClient").toString());
        return new DatarouterRedisClient(this.clientType, clientId, (RedisClusterAsyncCommands<byte[], byte[]>)lettuceClient);
    }

    private DatarouterRedisClient buildClusterClient(ClientId clientId) {
        PhaseTimer timer = new PhaseTimer(clientId.getName());
        RedisOptions.RedisClientMode mode = this.options.getClientMode(clientId.getName());
        ArrayList<RedisURI> redisUris = new ArrayList<RedisURI>();
        if (mode == RedisOptions.RedisClientMode.AUTO_DISCOVERY) {
            InetSocketAddress address2 = this.options.getEndpoint(clientId.getName()).get();
            String host = address2.getHostName();
            int port = address2.getPort();
            redisUris.add(RedisURI.create((String)host, (int)port));
        } else {
            Scanner.of(this.options.getNodes(clientId.getName())).map(address -> RedisURI.create((String)address.getHostName(), (int)address.getPort())).distinct().forEach(redisUris::add);
        }
        ClusterTopologyRefreshOptions refreshOptions = ClusterTopologyRefreshOptions.builder().enableAllAdaptiveRefreshTriggers().build();
        ClusterClientOptions clusterClientOptions = ClusterClientOptions.builder().topologyRefreshOptions(refreshOptions).validateClusterNodeMembership(false).build();
        RedisClusterClient redisClusterClient = RedisClusterClient.create(redisUris);
        redisClusterClient.setOptions(clusterClientOptions);
        RedisAdvancedClusterAsyncCommands lettuceClient = redisClusterClient.connect((RedisCodec)ByteArrayCodec.INSTANCE).async();
        logger.warn(timer.add("buildClusterClient").toString());
        return new DatarouterRedisClient(this.clientType, clientId, (RedisClusterAsyncCommands<byte[], byte[]>)lettuceClient);
    }

    public Supplier<DatarouterRedisClient> getLazyClient(ClientId clientId) {
        return SingletonSupplier.of(() -> this.getClient(clientId));
    }
}

