/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.redis.client;

import io.datarouter.client.redis.client.DatarouterRedisClient;
import io.datarouter.storage.client.ClientId;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Singleton
public class RedisClientHolder {
    private final Map<ClientId, DatarouterRedisClient> redisByClientId = new ConcurrentHashMap<ClientId, DatarouterRedisClient>();

    public void registerClient(ClientId clientId, DatarouterRedisClient client) {
        if (this.redisByClientId.containsKey(clientId)) {
            throw new RuntimeException(String.valueOf(clientId) + " already registered a RedisClient");
        }
        this.redisByClientId.put(clientId, client);
    }

    public DatarouterRedisClient get(ClientId clientId) {
        return this.redisByClientId.get(clientId);
    }
}

