/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.redis.codec;

import io.datarouter.bytes.ByteTool;
import io.datarouter.bytes.codec.stringcodec.StringCodec;
import io.datarouter.storage.file.PathbeanKey;
import io.datarouter.storage.util.Subpath;
import io.lettuce.core.KeyValue;
import java.util.List;
import java.util.Optional;

public class RedisBlobCodec {
    private final byte[] pathBytes;

    public RedisBlobCodec(Subpath path) {
        this.pathBytes = StringCodec.UTF_8.encode(path.toString());
    }

    public byte[] encodeKey(PathbeanKey pk) {
        byte[] pkBytes = StringCodec.UTF_8.encode(pk.getPathAndFile());
        return ByteTool.concat((byte[][])new byte[][]{this.pathBytes, pkBytes});
    }

    public byte[][] encodeKeys(List<PathbeanKey> pks) {
        byte[][] encodedKeys = new byte[pks.size()][];
        int i = 0;
        while (i < pks.size()) {
            encodedKeys[i] = this.encodeKey(pks.get(i));
            ++i;
        }
        return encodedKeys;
    }

    public PathbeanKey decodeKey(byte[] fullBytesKey) {
        int offset = this.pathBytes.length;
        int length = fullBytesKey.length - offset;
        String pkString = StringCodec.UTF_8.decode(fullBytesKey, offset, length);
        return PathbeanKey.of((String)pkString);
    }

    public PathbeanKey decodeKey(KeyValue<byte[], byte[]> kv) {
        return Optional.of(kv).map(KeyValue::getKey).map(this::decodeKey).orElseThrow();
    }
}

